/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.ConfPairs;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.util.X509Util;

public class HttpsHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsHostnameVerifier.class);
    private boolean enabled;
    private boolean trustAll;
    private Map<String, Set<String>> hostnameMap = new ConcurrentHashMap<String, Set<String>>();
    private HostnameVerifier oldHostnameVerifier;
    private boolean meAsDefaultHostnameVerifier;

    public void init() {
        LOG.info("enabled: {}", (Object)this.enabled);
        LOG.info("trustAll: {}", (Object)this.trustAll);
        if (this.enabled) {
            this.oldHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            LOG.info("Register me as DefaultHostnameVerifier, and backup the old one {}", (Object)this.oldHostnameVerifier);
            HttpsURLConnection.setDefaultHostnameVerifier(this);
            this.meAsDefaultHostnameVerifier = true;
        }
    }

    public void shutdown() {
        if (this.meAsDefaultHostnameVerifier && HttpsURLConnection.getDefaultHostnameVerifier() == this) {
            LOG.info("Unregister me as DefaultHostnameVerifier, and reuse the old one {}", (Object)this.oldHostnameVerifier);
            HttpsURLConnection.setDefaultHostnameVerifier(this.oldHostnameVerifier);
            this.meAsDefaultHostnameVerifier = false;
        }
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        ParamUtil.requireNonNull((String)"hostname", (Object)hostname);
        if (this.trustAll) {
            return true;
        }
        LOG.info("hostname: {}", (Object)hostname);
        String commonName = null;
        try {
            Principal peerPrincipal = session.getPeerPrincipal();
            if (peerPrincipal == null) {
                return false;
            }
            commonName = X509Util.getCommonName(new X500Name(peerPrincipal.getName()));
            LOG.info("commonName: {}", (Object)commonName);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
        Set<String> hostnames = this.hostnameMap.get(commonName);
        return hostnames == null ? false : hostnames.contains(hostname);
    }

    public void setCommonnameHostMap(String commonnameHostMap) {
        this.hostnameMap.clear();
        if (StringUtil.isBlank((String)commonnameHostMap)) {
            return;
        }
        ConfPairs pairs = new ConfPairs(commonnameHostMap);
        Set commonNames = pairs.names();
        for (String commonName : commonNames) {
            String str = pairs.value(commonName);
            Set hosts = StringUtil.splitAsSet((String)str, (String)",; \t");
            this.hostnameMap.put(commonName, hosts);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }
}

