/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.concurrent.ConcurrentBagEntry;
import org.xipki.common.util.ParamUtil;

public class FpIdCalculator {
    private static final int PARALLELISM = 50;
    private static final ConcurrentBag<ConcurrentBagEntry<Digest>> MDS = FpIdCalculator.getMD5MessageDigests();

    private FpIdCalculator() {
    }

    private static ConcurrentBag<ConcurrentBagEntry<Digest>> getMD5MessageDigests() {
        ConcurrentBag mds = new ConcurrentBag();
        for (int i = 0; i < 50; ++i) {
            SHA1Digest md = new SHA1Digest();
            mds.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)md));
        }
        return mds;
    }

    public static long hash(String data) {
        byte[] encoded;
        ParamUtil.requireNonNull((String)"data", (Object)data);
        try {
            encoded = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            encoded = data.getBytes();
        }
        return FpIdCalculator.hash(encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hash(byte[] data) {
        ParamUtil.requireNonNull((String)"data", (Object)data);
        ConcurrentBagEntry md0 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                md0 = (ConcurrentBagEntry)MDS.borrow(10L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (md0 == null) {
            throw new RuntimeOperatorException("could not get idle MessageDigest");
        }
        try {
            Digest md = (Digest)md0.value();
            md.reset();
            md.update(data, 0, data.length);
            byte[] bytes = new byte[md.getDigestSize()];
            md.doFinal(bytes, 0);
            long l = FpIdCalculator.bytesToLong(bytes);
            return l;
        }
        finally {
            MDS.requite((ConcurrentBag.IConcurrentBagEntry)md0);
        }
    }

    private static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, 8);
        buffer.flip();
        return buffer.getLong();
    }
}

