/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class OBFPasswordService {
    public static final String OBFUSCATE = "OBF:";

    public static String obfuscate(String str) {
        Objects.requireNonNull(str, "str must not be null");
        StringBuilder buf = new StringBuilder();
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.append(OBFUSCATE);
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = bytes[i];
            byte b2 = bytes[bytes.length - (i + 1)];
            if (b1 < 0 || b2 < 0) {
                int i0 = (0xFF & b1) * 256 + (0xFF & b2);
                String sx = Integer.toString(i0, 36).toLowerCase();
                buf.append("U0000", 0, 5 - sx.length());
                buf.append(sx);
                continue;
            }
            int i1 = 127 + b1 + b2;
            int i2 = 127 + b1 - b2;
            int i0 = i1 * 256 + i2;
            String sx = Integer.toString(i0, 36).toLowerCase();
            buf.append("000", 0, 4 - sx.length());
            buf.append(sx);
        }
        return buf.toString();
    }

    public static String deobfuscate(String str) {
        Objects.requireNonNull(str, "str must not be null");
        String tmpStr = str;
        if (OBFPasswordService.startsWithIgnoreCase(tmpStr, OBFUSCATE)) {
            tmpStr = tmpStr.substring(4);
        }
        byte[] bytes = new byte[tmpStr.length() / 2];
        int idx = 0;
        for (int i = 0; i < tmpStr.length(); i += 4) {
            int i0;
            String sx;
            if (tmpStr.charAt(i) == 'U') {
                sx = tmpStr.substring(++i, i + 4);
                i0 = Integer.parseInt(sx, 36);
                byte bx = (byte)(i0 >> 8);
                bytes[idx++] = bx;
                continue;
            }
            sx = tmpStr.substring(i, i + 4);
            i0 = Integer.parseInt(sx, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            byte bx = (byte)((i1 + i2 - 254) / 2);
            bytes[idx++] = bx;
        }
        return new String(bytes, 0, idx, StandardCharsets.UTF_8);
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str.length() < prefix.length()) {
            return false;
        }
        return prefix.equalsIgnoreCase(str.substring(0, prefix.length()));
    }
}

