/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.SimpleXpath;
import org.xipki.common.util.StringUtil;
import org.xml.sax.SAXException;

public class XmlUtil {
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static Document document;
    private static DocumentBuilder builder;

    private XmlUtil() {
    }

    public static Element createElement(String namespace, String localPart, String value) {
        if (document == null) {
            throw new RuntimeException("XMLDocumentBuilder must not be initialized");
        }
        ParamUtil.requireNonBlank("localPart", localPart);
        Element element = document.createElementNS(namespace, "ns:" + localPart);
        if (StringUtil.isNotBlank(value)) {
            element.appendChild(document.createTextNode(value));
        }
        return element;
    }

    public static Element getDocumentElment(byte[] xmlFragement) throws IOException, SAXException {
        ParamUtil.requireNonNull("xmlFragement", xmlFragement);
        Document doc = builder.parse(new ByteArrayInputStream(xmlFragement));
        return doc.getDocumentElement();
    }

    public static Calendar getCalendar(Date dateAndTime) {
        if (null == dateAndTime) {
            return null;
        }
        Calendar cal = (Calendar)Calendar.getInstance(UTC).clone();
        cal.setTime(dateAndTime);
        return cal;
    }

    public static XMLGregorianCalendar currentXmlDate() {
        return XmlUtil.getXmlDate(new Date());
    }

    public static XMLGregorianCalendar getXmlDate(Calendar calendar) {
        GregorianCalendar cal;
        ParamUtil.requireNonNull("calendar", calendar);
        if (calendar instanceof GregorianCalendar) {
            cal = (GregorianCalendar)calendar;
        } else {
            cal = new GregorianCalendar();
            cal.setTimeZone(UTC);
            cal.setTime(calendar.getTime());
        }
        try {
            XMLGregorianCalendar ret = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            ret.setMillisecond(Integer.MIN_VALUE);
            return ret;
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
    }

    public static XMLGregorianCalendar getXmlDate(Date dateAndTime) {
        ParamUtil.requireNonNull("dateAndTime", dateAndTime);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(UTC);
        cal.setTime(dateAndTime);
        try {
            XMLGregorianCalendar ret = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            ret.setMillisecond(Integer.MIN_VALUE);
            return ret;
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
    }

    public static String getValueOfFirstElementChild(Element element, String namespace, String localname) {
        Element node = XmlUtil.getFirstElementChild(element, namespace, localname);
        return node == null ? null : XmlUtil.getNodeValue(node);
    }

    public static String getNodeValue(Node node) {
        Node cn;
        ParamUtil.requireNonNull("node", node);
        if (node.getNodeType() == 1 && (cn = node.getFirstChild()) != null) {
            do {
                if (cn.getNodeType() != 3) continue;
                return cn.getNodeValue();
            } while ((cn = cn.getNextSibling()) != null);
        }
        return node.getNodeValue();
    }

    public static Element getFirstElementChild(Element element, String namespace, String localname) {
        ParamUtil.requireNonNull("element", element);
        ParamUtil.requireNonBlank("localname", localname);
        Node node = element.getFirstChild();
        if (node == null) {
            return null;
        }
        do {
            if (!XmlUtil.match(node, namespace, localname)) continue;
            return (Element)node;
        } while ((node = node.getNextSibling()) != null);
        return null;
    }

    public static List<Element> getElementChilden(Element element, String namespace, String localname) {
        ParamUtil.requireNonNull("element", element);
        ParamUtil.requireNonBlank("localname", localname);
        LinkedList<Element> rv = new LinkedList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!XmlUtil.match(child, namespace, localname)) continue;
            rv.add((Element)child);
        }
        return rv;
    }

    public static List<Element> getAllElementsWithAttrId(Element element, String namespace) {
        ParamUtil.requireNonNull("element", element);
        LinkedList<Element> list = new LinkedList<Element>();
        if (XmlUtil.elementHasId(element, namespace)) {
            list.add(element);
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            XmlUtil.addAllElementsWithAttrId(list, (Element)child, namespace);
        }
        return list;
    }

    private static void addAllElementsWithAttrId(List<Element> list, Element element, String namespace) {
        if (XmlUtil.elementHasId(element, namespace)) {
            list.add(element);
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (XmlUtil.elementHasId(childElement, namespace)) {
                list.add(childElement);
            }
            XmlUtil.addAllElementsWithAttrId(list, childElement, namespace);
        }
    }

    private static boolean elementHasId(Element element, String namespace) {
        return element.hasAttributeNS(namespace, "Id");
    }

    private static boolean match(Node node, String namespace, String localname) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String ln = element.getLocalName();
            if (ln == null) {
                ln = element.getTagName();
            }
            if (ln.equals(localname) && (namespace == null || namespace.equals(element.getNamespaceURI()))) {
                return true;
            }
        }
        return false;
    }

    public static String getValueOfFirstMatch(Element contextNode, String relativeXpath, Map<String, String> nsPrefixUriMap) {
        Node node = XmlUtil.getFirstMatch(contextNode, relativeXpath, nsPrefixUriMap);
        return node == null ? null : XmlUtil.getNodeValue(node);
    }

    public static Node getFirstMatch(Element contextNode, String relativeXPath, Map<String, String> nsPrefixUriMap) {
        List<Node> nodes = XmlUtil.getMatch(contextNode, relativeXPath, nsPrefixUriMap, true);
        return CollectionUtil.isEmpty(nodes) ? null : nodes.get(0);
    }

    public static List<Node> getMatch(Element contextNode, String relativeXPath, Map<String, String> nsPrefixUriMap) {
        return XmlUtil.getMatch(contextNode, relativeXPath, nsPrefixUriMap, false);
    }

    private static List<Node> getMatch(Element contextNode, String relativeXpath, Map<String, String> nsPrefixUriMap, boolean onlyFirstMatch) {
        try {
            SimpleXpath simpleXpath = new SimpleXpath(relativeXpath, nsPrefixUriMap);
            if (onlyFirstMatch) {
                Node node = simpleXpath.selectFirstMatch(contextNode);
                return node == null ? Collections.emptyList() : Arrays.asList(node);
            }
            return simpleXpath.select(contextNode);
        }
        catch (XPathExpressionException ex) {
            System.err.println("invalid xpath {}" + relativeXpath);
            return Collections.emptyList();
        }
    }

    public static List<Element> getElementMatch(Element contextNode, String relativeXpath, Map<String, String> nsPrefixUriMap) {
        List<Node> nodes = XmlUtil.getMatch(contextNode, relativeXpath, nsPrefixUriMap, false);
        ArrayList<Element> elements = new ArrayList<Element>(nodes.size());
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static String getMessage(JAXBException ex) {
        ParamUtil.requireNonNull("ex", ex);
        String ret = ex.getMessage();
        if (ret == null && ex.getLinkedException() != null) {
            ret = ex.getLinkedException().getMessage();
        }
        return ret;
    }

    public static JAXBException convert(JAXBException ex) {
        ParamUtil.requireNonNull("ex", ex);
        return new JAXBException(XmlUtil.getMessage(ex), ex.getLinkedException());
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new ExceptionInInitializerError(new Exception("could not initialize the XMLDocumentBuilder", ex));
        }
        if (builder != null) {
            document = builder.newDocument();
        }
    }
}

