/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.xipki.common.util.ParamUtil;

public class StringUtil {
    private StringUtil() {
    }

    public static List<String> split(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        ArrayList<String> ret = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return str != null && !str.isEmpty();
    }

    public static Set<String> splitAsSet(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return Collections.emptySet();
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        HashSet<String> ret = new HashSet<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static String collectionAsString(Collection<String> set, String delim) {
        if (set == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String m : set) {
            sb.append(m).append(delim);
        }
        int len = sb.length();
        if (len > 0) {
            sb.delete(len - delim.length(), len);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str.length() < prefix.length()) {
            return false;
        }
        return prefix.equalsIgnoreCase(str.substring(0, prefix.length()));
    }

    public static boolean isNumber(String str) {
        return StringUtil.isNumber(str, 10);
    }

    public static boolean isNumber(String str, int radix) {
        ParamUtil.requireNonNull("str", str);
        try {
            Integer.parseInt(str, radix);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static String formatText(String text, int minLen) {
        ParamUtil.requireNonNull("text", text);
        int len = text.length();
        if (len >= minLen) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < minLen - len; ++i) {
            sb.append(" ");
        }
        sb.append(text);
        return sb.toString();
    }

    public static String formatAccount(long account, boolean withPrefix) {
        int minLen = withPrefix ? 12 : 0;
        return StringUtil.formatAccount(account, minLen);
    }

    public static String formatAccount(long account, int minLen) {
        String accountS = Long.toString(account);
        int n = accountS.length();
        if (n > 3) {
            int offset;
            StringBuilder sb = new StringBuilder(n + 3);
            int firstBlockLen = n % 3;
            if (firstBlockLen != 0) {
                sb.append(accountS.substring(0, firstBlockLen));
                sb.append(',');
            }
            int i = 0;
            while ((offset = firstBlockLen + i * 3) < n) {
                sb.append(accountS.substring(offset, offset + 3));
                if (offset + 3 < n) {
                    sb.append(',');
                }
                ++i;
            }
            accountS = sb.toString();
        }
        return StringUtil.formatText(accountS, minLen);
    }

    public static String formatTime(long seconds, boolean withPrefix) {
        int minLen = withPrefix ? 12 : 0;
        return StringUtil.formatTime(seconds, minLen);
    }

    private static String formatTime(long seconds, int minLen) {
        long modMinute;
        long minutes = seconds / 60L;
        StringBuilder sb = new StringBuilder();
        long hour = minutes / 60L;
        if (hour > 0L) {
            sb.append(hour).append(':');
        }
        if ((modMinute = minutes % 60L) < 10L) {
            sb.append('0');
        }
        sb.append(modMinute).append(':');
        long modSec = seconds % 60L;
        if (modSec < 10L) {
            sb.append('0');
        }
        sb.append(modSec);
        return StringUtil.formatText(sb.toString(), minLen);
    }

    public static char[] merge(char[][] parts) {
        int sum = 0;
        for (int i = 0; i < parts.length; ++i) {
            sum += parts[i].length;
        }
        char[] ret = new char[sum];
        int destPos = 0;
        for (int i = 0; i < parts.length; ++i) {
            char[] part = parts[i];
            System.arraycopy(part, 0, ret, destPos, part.length);
            destPos += part.length;
        }
        return ret;
    }
}

