/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.XmlUtil;

public class SimpleXpath {
    private final List<SimpleXpathStep> steps;

    public SimpleXpath(String relativeXpath, Map<String, String> nsPrefixUriMap) throws XPathExpressionException {
        ParamUtil.requireNonBlank("relativeXpath", relativeXpath);
        if (relativeXpath.startsWith("/")) {
            throw new XPathExpressionException(relativeXpath + " is no a relative xpath");
        }
        StringTokenizer st = new StringTokenizer(relativeXpath, "/");
        this.steps = new ArrayList<SimpleXpathStep>(st.countTokens());
        int countTokens = st.countTokens();
        int stepNo = 1;
        while (st.hasMoreTokens()) {
            String step = st.nextToken();
            int idx = step.indexOf(64);
            if (idx != -1) {
                if (stepNo != countTokens) {
                    throw new XPathExpressionException("attribute is only allowed in the last step");
                }
                if (idx > 0) {
                    this.steps.add(new SimpleXpathStep(step.substring(0, idx), nsPrefixUriMap));
                }
                this.steps.add(new SimpleXpathStep(step.substring(idx), nsPrefixUriMap));
            } else {
                this.steps.add(new SimpleXpathStep(step, nsPrefixUriMap));
            }
            ++stepNo;
        }
    }

    public List<Node> select(Element context) {
        LinkedList<Node> rv = new LinkedList<Node>();
        SimpleXpath.select(rv, context, this.steps, 0, false);
        return rv;
    }

    private static void select(List<Node> results, Element context, List<SimpleXpathStep> steps, int stepIndex, boolean onlyFirst) {
        if (onlyFirst && CollectionUtil.isNonEmpty(results)) {
            return;
        }
        ParamUtil.requireNonNull("context", context);
        ParamUtil.requireNonNull("steps", steps);
        SimpleXpathStep step = steps.get(stepIndex);
        if (step.isElement) {
            List<Element> children = XmlUtil.getElementChilden(context, step.namespaceUri, step.localPart);
            if (steps.size() == stepIndex + 1) {
                results.addAll(children);
            } else {
                for (Element child : children) {
                    SimpleXpath.select(results, child, steps, stepIndex + 1, onlyFirst);
                }
            }
        } else {
            Attr attr = context.getAttributeNodeNS(step.namespaceUri, step.localPart);
            if (attr == null && step.namespaceUri == null) {
                attr = context.getAttributeNode(step.localPart);
            }
            if (attr != null) {
                results.add(attr);
            }
        }
    }

    public Node selectFirstMatch(Element context) {
        LinkedList<Node> rv = new LinkedList<Node>();
        SimpleXpath.select(rv, context, this.steps, 0, true);
        return CollectionUtil.isEmpty(rv) ? null : (Node)rv.get(0);
    }

    private static class SimpleXpathStep {
        private final String namespaceUri;
        private final String localPart;
        private boolean isElement = true;

        SimpleXpathStep(String step, Map<String, String> nsPrefixUriMap) throws XPathExpressionException {
            String prefix;
            int idx;
            String tmpStep = ParamUtil.requireNonBlank("step", step);
            if (tmpStep.charAt(0) == '@') {
                this.isElement = false;
                tmpStep = tmpStep.substring(1);
            }
            if ((idx = tmpStep.indexOf(58)) != -1) {
                prefix = tmpStep.substring(0, idx);
                this.localPart = tmpStep.substring(idx + 1);
            } else {
                prefix = this.isElement ? "" : null;
                this.localPart = tmpStep;
            }
            if (nsPrefixUriMap != null && prefix != null) {
                this.namespaceUri = nsPrefixUriMap.get(prefix);
                if (this.namespaceUri == null) {
                    throw new XPathExpressionException("could not find namespace for the prefix '" + prefix + "'");
                }
            } else {
                this.namespaceUri = null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isElement ? "Element" : "Attribute");
            sb.append(" localPart='").append(this.localPart).append("'");
            sb.append(" namespace='").append(this.namespaceUri).append("'");
            return sb.toString();
        }
    }
}

