/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.xipki.common.util.BigIntegerRange;
import org.xipki.common.util.ParamUtil;

public class RangeBigIntegerIterator
implements Iterator<BigInteger> {
    private final List<BigIntegerRange> ranges;
    private final int sizeRanges;
    private final boolean loop;
    private int currentIndex;
    private BigInteger currentNumber;

    public RangeBigIntegerIterator(List<BigIntegerRange> ranges, boolean loop) {
        this.ranges = ParamUtil.requireNonEmpty("ranges", ranges);
        this.sizeRanges = ranges.size();
        this.loop = loop;
        this.currentIndex = 0;
        this.currentNumber = ranges.get(0).from();
    }

    @Override
    public synchronized boolean hasNext() {
        return this.currentNumber != null;
    }

    @Override
    public synchronized BigInteger next() {
        if (this.currentNumber == null) {
            return null;
        }
        BigInteger ret = this.currentNumber;
        BigInteger nextNumber = this.currentNumber.add(BigInteger.ONE);
        BigIntegerRange range = this.ranges.get(this.currentIndex);
        if (range.isInRange(nextNumber)) {
            this.currentNumber = nextNumber;
        } else {
            ++this.currentIndex;
            if (this.loop && this.currentIndex >= this.sizeRanges) {
                this.currentIndex = 0;
            }
            this.currentNumber = this.currentIndex < this.sizeRanges ? this.ranges.get(this.currentIndex).from() : null;
        }
        return ret;
    }
}

