/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ParamUtil {
    private ParamUtil() {
    }

    public static int requireMin(String objName, int obj, int min) {
        if (obj < min) {
            throw new IllegalArgumentException(String.format("%s must not be less than %d: %d", objName, min, obj));
        }
        return obj;
    }

    public static long requireMin(String objName, long obj, long min) {
        if (obj < min) {
            throw new IllegalArgumentException(String.format("%s must not be less than %d: %d", objName, min, obj));
        }
        return obj;
    }

    public static int requireMax(String objName, int obj, int max) {
        if (obj > max) {
            throw new IllegalArgumentException(String.format("%s must not be greater than %d: %d", objName, max, obj));
        }
        return obj;
    }

    public static long requireMax(String objName, long obj, long max) {
        if (obj > max) {
            throw new IllegalArgumentException(String.format("%s must not be greater than %d: %d", objName, max, obj));
        }
        return obj;
    }

    public static int requireRange(String objName, int obj, int min, int max) {
        if (obj < min || obj > max) {
            throw new IllegalArgumentException(String.format("%s must not be out of the range [%d, %d]: %d", objName, min, max, obj));
        }
        return obj;
    }

    public static long requireRange(String objName, long obj, long min, long max) {
        if (obj < min || obj > max) {
            throw new IllegalArgumentException(String.format("%s must not be out of the range [%d, %d]: %d", objName, min, max, obj));
        }
        return obj;
    }

    public static <T> T requireNonNull(String objName, T obj) {
        return Objects.requireNonNull(obj, objName + " must not be null");
    }

    public static String requireNonBlank(String objName, String obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be blank");
        }
        return obj;
    }

    public static <T> Collection<T> requireNonEmpty(String objName, Collection<T> obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be empty");
        }
        return obj;
    }

    public static <T> Set<T> requireNonEmpty(String objName, Set<T> obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be empty");
        }
        return obj;
    }

    public static <T> List<T> requireNonEmpty(String objName, List<T> obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be empty");
        }
        return obj;
    }

    public static <K, V> Map<K, V> requireNonEmpty(String objName, Map<K, V> obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be empty");
        }
        return obj;
    }

    public static <K, V> Dictionary<K, V> requireNonEmpty(String objName, Dictionary<K, V> obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be empty");
        }
        return obj;
    }
}

