/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.math.BigInteger;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.xipki.common.util.XmlUtil;

public class LogUtil {
    private LogUtil() {
    }

    public static void error(Logger log, Throwable th) {
        if (!log.isErrorEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}), {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), th.getClass().getName(), LogUtil.getMessage(th)});
        } else {
            log.error("{}: {}", (Object)th.getClass().getName(), (Object)LogUtil.getMessage(th));
        }
        log.debug("Exception", th);
    }

    public static void error(Logger log, Throwable th, String msg) {
        if (!log.isErrorEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}) {}, {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), msg, th.getClass().getName(), LogUtil.getMessage(th)});
        } else {
            log.error("{}, {}: {}", new Object[]{msg, th.getClass().getName(), LogUtil.getMessage(th)});
        }
        log.debug(msg, th);
    }

    public static void warn(Logger log, Throwable th) {
        if (!log.isWarnEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.error("({} {}), {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), th.getClass().getName(), LogUtil.getMessage(th)});
        } else {
            log.warn("{}: {}", (Object)th.getClass().getName(), (Object)LogUtil.getMessage(th));
        }
        log.debug("Exception", th);
    }

    public static void warn(Logger log, Throwable th, String msg) {
        if (!log.isWarnEnabled()) {
            return;
        }
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (traces.length > 2) {
            StackTraceElement trace = traces[2];
            log.warn("({} {}) {}, {}: {}", new Object[]{trace.getMethodName(), trace.getLineNumber(), msg, th.getClass().getName(), LogUtil.getMessage(th)});
        } else {
            log.warn("{}, {}: {}", new Object[]{msg, th.getClass().getName(), LogUtil.getMessage(th)});
        }
        log.debug(msg, th);
    }

    public static String formatCsn(BigInteger serialNumber) {
        return "0x" + serialNumber.toString(16);
    }

    private static String getMessage(Throwable th) {
        return th instanceof JAXBException ? XmlUtil.getMessage((JAXBException)th) : th.getMessage();
    }
}

