/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.ParamUtil;

public class IoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IoUtil.class);

    private IoUtil() {
    }

    public static void closeStream(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Throwable th) {
            LOG.error("could not close stream: {}", (Object)th.getMessage());
        }
    }

    public static byte[] read(String fileName) throws IOException {
        return IoUtil.read(new File(IoUtil.expandFilepath(fileName)));
    }

    public static byte[] read(File file) throws IOException {
        return IoUtil.read(new FileInputStream(IoUtil.expandFilepath(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int readed = 0;
            byte[] buffer = new byte[2048];
            while ((readed = in.read(buffer)) != -1) {
                bout.write(buffer, 0, readed);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                LOG.error("could not close stream: {}", (Object)ex.getMessage());
            }
        }
    }

    public static void save(String fileName, byte[] encoded) throws IOException {
        IoUtil.save(new File(IoUtil.expandFilepath(fileName)), encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] content) throws IOException {
        File tmpFile = IoUtil.expandFilepath(file);
        File parent = tmpFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(tmpFile);){
            out.write(content);
        }
    }

    public static String getHostAddress() throws SocketException {
        LinkedList<String> addresses = new LinkedList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            Iterator ni = interfaces.nextElement();
            Enumeration<InetAddress> ee = ((NetworkInterface)((Object)ni)).getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress ia = ee.nextElement();
                if (!(ia instanceof Inet4Address)) continue;
                addresses.add(ia.getHostAddress());
            }
        }
        for (String addr : addresses) {
            if (addr.startsWith("192.") || addr.startsWith("127.")) continue;
            return addr;
        }
        for (String addr : addresses) {
            if (addr.startsWith("127.")) continue;
            return addr;
        }
        if (addresses.size() > 0) {
            return (String)addresses.get(0);
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "UNKNOWN";
        }
    }

    public static String expandFilepath(String path) {
        ParamUtil.requireNonBlank("path", path);
        return path.startsWith("~" + File.separator) ? System.getProperty("user.home") + path.substring(1) : path;
    }

    public static File expandFilepath(File file) {
        String expandedPath;
        String path = file.getPath();
        if (path.equals(expandedPath = IoUtil.expandFilepath(path))) {
            return file;
        }
        return new File(expandedPath);
    }

    public static String convertSequenceName(String sequenceName) {
        StringBuilder sb = new StringBuilder();
        int len = sequenceName.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequenceName.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    public static void writeShort(short value, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(value >> 8);
        dest[destOffset] = (byte)(0xFF & value);
    }

    public static short parseShort(byte[] bytes, int offset) {
        return (short)((0xFF & bytes[offset++]) << 8 | 0xFF & bytes[offset]);
    }

    public static void writeInt(int value, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(value >> 24);
        dest[destOffset++] = (byte)(0xFF & value >> 16);
        dest[destOffset++] = (byte)(0xFF & value >> 8);
        dest[destOffset] = (byte)(0xFF & value);
    }

    public static int parseInt(byte[] bytes, int offset) {
        return (0xFF & bytes[offset++]) << 24 | (0xFF & bytes[offset++]) << 16 | (0xFF & bytes[offset++]) << 8 | 0xFF & bytes[offset];
    }

    public static int getIndex(byte[] arrayA, byte[] arrayB) {
        int endIndex = arrayA.length - arrayB.length;
        for (int i = 0; i < endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < arrayB.length; ++j) {
                if (arrayA[i + j] == arrayB[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static String base64Encode(byte[] data, boolean withLineBreak) {
        String b64Str = Base64.getEncoder().encodeToString(data);
        if (!withLineBreak) {
            return b64Str;
        }
        if (b64Str.length() < 64) {
            return b64Str;
        }
        StringBuilder sb = new StringBuilder();
        int blockSize = 64;
        int size = b64Str.length();
        int nFullBlock = size / 64;
        for (int i = 0; i < nFullBlock; ++i) {
            int offset = i * 64;
            sb.append(b64Str.subSequence(offset, offset + 64)).append("\n");
        }
        if (size % 64 != 0) {
            sb.append(b64Str.substring(nFullBlock * 64)).append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static HttpURLConnection openHttpConn(URL url) throws IOException {
        ParamUtil.requireNonNull("url", url);
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            return (HttpURLConnection)conn;
        }
        throw new IOException(url.toString() + " is not of protocol HTTP: " + url.getProtocol());
    }
}

