/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xipki.common.util.ParamUtil;

public class FileBigIntegerIterator
implements Iterator<BigInteger> {
    private final boolean hex;
    private final boolean loop;
    private final String fileName;
    private BufferedReader reader;
    private ConcurrentLinkedQueue<BigInteger> nextNumbers = new ConcurrentLinkedQueue();
    private BigInteger currentNumber;

    public FileBigIntegerIterator(String fileName, boolean hex, boolean loop) throws IOException {
        this.fileName = ParamUtil.requireNonBlank("fileName", fileName);
        this.hex = hex;
        this.loop = loop;
        this.reader = new BufferedReader(new FileReader(fileName));
        this.currentNumber = this.readNextNumber();
    }

    @Override
    public synchronized boolean hasNext() {
        return this.currentNumber != null;
    }

    @Override
    public synchronized BigInteger next() {
        if (this.currentNumber == null) {
            return null;
        }
        BigInteger ret = this.currentNumber;
        this.currentNumber = this.readNextNumber();
        return ret;
    }

    private BigInteger readNextNumber() {
        String line;
        BigInteger number = this.nextNumbers.poll();
        if (number != null) {
            return number;
        }
        try {
            line = this.reader.readLine();
            if (this.loop && line == null) {
                this.reader.close();
                this.reader = new BufferedReader(new FileReader(this.fileName));
                line = this.reader.readLine();
            }
            if (line == null) {
                this.reader.close();
                return null;
            }
        }
        catch (IOException ex) {
            throw new NoSuchElementException("could not read next number from file " + this.fileName);
        }
        if (line.indexOf(44) == -1) {
            this.nextNumbers.add(new BigInteger(line.trim(), this.hex ? 16 : 10));
        } else {
            StringTokenizer st = new StringTokenizer(line.trim(), ", ");
            while (st.hasMoreTokens()) {
                this.nextNumbers.add(new BigInteger(st.nextToken(), this.hex ? 16 : 10));
            }
        }
        return this.nextNumbers.poll();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

