/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.util;

import java.math.BigInteger;

public class BigIntegerRange {
    private final BigInteger from;
    private final BigInteger to;
    private final BigInteger diff;

    public BigIntegerRange(BigInteger from, BigInteger to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException("from (" + from + ") must not be larger than to (" + to + ")");
        }
        this.from = from;
        this.to = to;
        this.diff = to.subtract(from);
    }

    public BigInteger from() {
        return this.from;
    }

    public BigInteger to() {
        return this.to;
    }

    public BigInteger diff() {
        return this.diff;
    }

    public boolean isInRange(BigInteger num) {
        return num.compareTo(this.from) >= 0 && num.compareTo(this.to) <= 0;
    }
}

