/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.qa;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xipki.common.qa.ValidationIssue;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;

public class ValidationResult {
    private final List<ValidationIssue> validationIssues;
    private final List<ValidationIssue> failedValidationIssues;
    private final List<ValidationIssue> successfulValidationIssues;

    public ValidationResult(ValidationIssue validationIssues) {
        this(Arrays.asList(validationIssues));
    }

    public ValidationResult(List<ValidationIssue> validationIssues) {
        this.validationIssues = ParamUtil.requireNonEmpty("validationIssues", validationIssues);
        LinkedList<ValidationIssue> failedIssues = new LinkedList<ValidationIssue>();
        LinkedList<ValidationIssue> successfulIssues = new LinkedList<ValidationIssue>();
        for (ValidationIssue issue : validationIssues) {
            if (issue.isFailed()) {
                failedIssues.add(issue);
                continue;
            }
            successfulIssues.add(issue);
        }
        this.failedValidationIssues = failedIssues;
        this.successfulValidationIssues = successfulIssues;
    }

    public boolean isAllSuccessful() {
        return CollectionUtil.isEmpty(this.failedValidationIssues);
    }

    public List<ValidationIssue> validationIssues() {
        return this.validationIssues;
    }

    public List<ValidationIssue> failedValidationIssues() {
        return this.failedValidationIssues;
    }

    public List<ValidationIssue> successfulValidationIssues() {
        return this.successfulValidationIssues;
    }
}

