/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountLatch {
    private final Sync sync;
    private final AtomicLong count;
    private volatile long releaseValue;

    public CountLatch(long initial, long releaseValue) {
        this.releaseValue = releaseValue;
        this.count = new AtomicLong(initial);
        this.sync = new Sync();
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public long countUp() {
        long current = this.count.incrementAndGet();
        if (current == this.releaseValue) {
            this.sync.releaseShared(0);
        }
        return current;
    }

    public long countDown() {
        long current = this.count.decrementAndGet();
        if (current == this.releaseValue) {
            this.sync.releaseShared(0);
        }
        return current;
    }

    public long getCount() {
        return this.count.get();
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        @Override
        protected int tryAcquireShared(int arg) {
            return CountLatch.this.count.get() == CountLatch.this.releaseValue ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            return true;
        }
    }
}

