/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.common.ProcessLog;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;

public abstract class LoadExecutor {
    private static final String PROPKEY_LOADTEST = "org.xipki.loadtest";
    private static final int DEFAULT_DURATION = 30;
    private static final int DEFAULT_THREADS = 25;
    private boolean interrupted;
    private String description;
    private final ProcessLog processLog;
    private int duration = 30;
    private int threads = 25;
    private AtomicLong errorAccount = new AtomicLong(0L);
    private String unit = "";

    public LoadExecutor(String description) {
        this.description = ParamUtil.requireNonNull("description", description);
        this.processLog = new ProcessLog(0L);
    }

    protected abstract Runnable getTestor() throws Exception;

    protected void shutdown() {
    }

    public void test() {
        System.getProperties().setProperty(PROPKEY_LOADTEST, "true");
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            Runnable runnable;
            try {
                runnable = this.getTestor();
            }
            catch (Exception ex) {
                System.err.println("could not initialize Testor: " + ex.getMessage());
                return;
            }
            runnables.add(runnable);
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotBlank(this.description)) {
            sb.append(this.description);
            char ch = this.description.charAt(this.description.length() - 1);
            if (ch != '\n') {
                sb.append('\n');
            }
        }
        sb.append("threads: ").append(this.threads).append("\n");
        sb.append("duration: ").append(StringUtil.formatTime((long)this.duration, false));
        System.out.println(sb.toString());
        this.resetStartTime();
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        for (Runnable runnable : runnables) {
            executor.execute(runnable);
        }
        executor.shutdown();
        this.printHeader();
        while (true) {
            this.printStatus();
            try {
                boolean terminated = executor.awaitTermination(1L, TimeUnit.SECONDS);
                if (!terminated) continue;
            }
            catch (InterruptedException ex) {
                this.interrupted = true;
                continue;
            }
            break;
        }
        this.printStatus();
        this.printSummary();
        this.shutdown();
        System.getProperties().remove(PROPKEY_LOADTEST);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setDuration(String duration) {
        int num;
        String numStr;
        ParamUtil.requireNonBlank("duration", duration);
        char unit = duration.charAt(duration.length() - 1);
        if (unit == 's' || unit == 'm' || unit == 'h') {
            numStr = duration.substring(0, duration.length() - 1);
        } else {
            unit = 's';
            numStr = duration;
        }
        try {
            num = Integer.parseInt(numStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        if (num < 1) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        switch (unit) {
            case 's': {
                this.duration = num;
                break;
            }
            case 'm': {
                this.duration = num * 60;
                break;
            }
            case 'h': {
                this.duration = num * 60 * 24;
                break;
            }
            default: {
                throw new RuntimeException("invalid duration unit " + unit);
            }
        }
    }

    public void setThreads(int threads) {
        if (threads > 0) {
            this.threads = threads;
        }
    }

    public long getErrorAccout() {
        return this.errorAccount.get();
    }

    public void account(int all, int failed) {
        this.processLog.addNumProcessed(all);
        this.errorAccount.addAndGet(failed);
    }

    protected void resetStartTime() {
        this.processLog.reset();
    }

    protected boolean stop() {
        return this.interrupted || this.errorAccount.get() > 0L || System.currentTimeMillis() - this.processLog.startTimeMs() >= (long)this.duration * 1000L;
    }

    protected void printHeader() {
        this.processLog.printHeader();
    }

    protected void printStatus() {
        this.processLog.printStatus();
    }

    public void setUnit(String unit) {
        this.unit = ParamUtil.requireNonNull("unit", unit);
    }

    protected void printSummary() {
        this.processLog.printTrailer();
        long account = this.processLog.numProcessed();
        StringBuilder sb = new StringBuilder(400);
        String text = new Date(this.processLog.startTimeMs()).toString();
        sb.append(" started at: ").append(text).append("\n");
        text = new Date(this.processLog.endTimeMs()).toString();
        sb.append("finished at: ").append(text).append("\n");
        long elapsedTimeMs = this.processLog.totalElapsedTime();
        text = StringUtil.formatTime(elapsedTimeMs / 1000L, false);
        sb.append("   duration: ").append(text).append("\n");
        text = StringUtil.formatAccount(account, 1);
        sb.append("    account: ").append(text).append(" ").append(this.unit).append("\n");
        text = StringUtil.formatAccount(this.errorAccount.get(), 1);
        sb.append("     failed: ").append(text).append(" ").append(this.unit).append("\n");
        text = StringUtil.formatAccount((long)this.processLog.totalAverageSpeed(), 1);
        sb.append("    average: ").append(text).append(" ").append(this.unit).append("/s\n");
        System.out.println(sb.toString());
    }

    protected static long getSecureIndex() {
        long nextLong;
        SecureRandom random = new SecureRandom();
        while ((nextLong = random.nextLong()) <= 0L) {
        }
        return nextLong;
    }
}

