/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;

public class HealthCheckResult {
    private String name;
    private boolean healthy;
    private Map<String, Object> statuses = new ConcurrentHashMap<String, Object>();
    private List<HealthCheckResult> childChecks = new LinkedList<HealthCheckResult>();

    public HealthCheckResult(String name) {
        this.name = ParamUtil.requireNonBlank("name", name);
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public void clearStatuses() {
        this.statuses.clear();
    }

    public Object status(String statusName) {
        return statusName == null ? null : this.statuses.get(statusName);
    }

    public void clearChildChecks() {
        this.childChecks.clear();
    }

    public void addChildCheck(HealthCheckResult childCheck) {
        ParamUtil.requireNonNull("childCheck", childCheck);
        this.childChecks.add(childCheck);
    }

    public Set<String> statusNames() {
        return this.statuses.keySet();
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public Map<String, Object> statuses() {
        return Collections.unmodifiableMap(this.statuses);
    }

    public String toJsonMessage(boolean pretty) {
        return this.toJsonMessage(0, pretty);
    }

    private String toJsonMessage(int level, boolean pretty) {
        StringBuilder sb = new StringBuilder(1000);
        if (pretty) {
            HealthCheckResult.addIndent(sb, level);
        }
        if (level > 0) {
            sb.append("\"").append(this.name).append("\":");
        }
        sb.append("{");
        boolean lastElement = true;
        if (lastElement && CollectionUtil.isNonEmpty(this.statuses)) {
            lastElement = false;
        }
        if (lastElement && CollectionUtil.isNonEmpty(this.childChecks)) {
            lastElement = false;
        }
        HealthCheckResult.append(sb, "healthy", this.healthy, level + 1, pretty, lastElement);
        Set<String> names = this.statuses.keySet();
        int size = names.size();
        int count = 0;
        for (String entry : names) {
            HealthCheckResult.append(sb, entry, this.statuses.get(entry), level + 1, pretty, CollectionUtil.isEmpty(this.childChecks) && ++count == size);
        }
        if (CollectionUtil.isNonEmpty(this.childChecks)) {
            if (pretty) {
                sb.append("\n");
                HealthCheckResult.addIndent(sb, level + 1);
            }
            sb.append("\"checks\":{");
            if (pretty) {
                sb.append("\n");
            }
            int childChecksSize = this.childChecks.size();
            for (int i = 0; i < childChecksSize; ++i) {
                HealthCheckResult childCheck = this.childChecks.get(i);
                if (i > 0 && pretty) {
                    sb.append("\n");
                }
                sb.append(childCheck.toJsonMessage(level + 2, pretty));
                if (i >= childChecksSize - 1) continue;
                sb.append(",");
            }
            if (pretty) {
                sb.append("\n");
                HealthCheckResult.addIndent(sb, level + 1);
            }
            sb.append("}");
        }
        if (pretty) {
            sb.append("\n");
            HealthCheckResult.addIndent(sb, level);
        }
        sb.append("}");
        return sb.toString();
    }

    private static void append(StringBuilder sb, String name, Object value, int level, boolean pretty, boolean lastElement) {
        if (pretty) {
            sb.append("\n");
            HealthCheckResult.addIndent(sb, level);
        }
        sb.append("\"").append(name).append("\":");
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof Boolean) {
            sb.append(value);
        } else {
            sb.append("\"").append(value).append("\"");
        }
        if (!lastElement) {
            sb.append(",");
        }
    }

    private static void addIndent(StringBuilder buffer, int level) {
        if (level == 0) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            buffer.append("    ");
        }
    }

    public static HealthCheckResult getInstanceFromJsonMessage(String name, String jsonMessage) {
        String jsonMsg = jsonMessage.replaceAll(" |\t|\r|\n", "");
        if (!jsonMsg.startsWith("{\"healthy\":")) {
            throw new IllegalArgumentException("invalid healthcheck message");
        }
        int startIdx = "{\"healthy\":".length();
        int endIdx = jsonMsg.indexOf(44, startIdx);
        boolean containsChildChecks = true;
        if (endIdx == -1) {
            endIdx = jsonMsg.indexOf(125, startIdx);
            containsChildChecks = false;
        }
        if (endIdx == -1) {
            throw new IllegalArgumentException("invalid healthcheck message");
        }
        String str = jsonMsg.substring(startIdx, endIdx);
        if (!"true".equalsIgnoreCase(str) && !"false".equalsIgnoreCase(str)) {
            throw new IllegalArgumentException("invalid healthcheck message");
        }
        boolean healthy = Boolean.parseBoolean(str);
        HealthCheckResult result = new HealthCheckResult(name);
        result.setHealthy(healthy);
        if (!containsChildChecks) {
            return result;
        }
        if (!jsonMsg.startsWith("\"checks\":", endIdx + 1)) {
            return result;
        }
        String checksBlock = HealthCheckResult.getBlock(jsonMsg, endIdx + 1 + "\"checks\":".length());
        String block = checksBlock.substring(1, checksBlock.length() - 1);
        Map<String, String> childBlocks = HealthCheckResult.getChildBlocks(block);
        for (String childBlockName : childBlocks.keySet()) {
            HealthCheckResult childResult = HealthCheckResult.getInstanceFromJsonMessage(childBlockName, childBlocks.get(childBlockName));
            result.addChildCheck(childResult);
        }
        return result;
    }

    private static Map<String, String> getChildBlocks(String block) {
        String blockValue;
        String blockName;
        HashMap<String, String> childBlocks = new HashMap<String, String>();
        int offset = 0;
        do {
            int idx = block.indexOf(34, offset + 1);
            blockName = block.substring(offset + 1, idx);
            blockValue = HealthCheckResult.getBlock(block, offset + blockName.length() + 3);
            childBlocks.put(blockName, blockValue);
        } while ((offset += blockName.length() + 4 + blockValue.length()) < block.length() - 1);
        return childBlocks;
    }

    private static String getBlock(String text, int offset) {
        if (!text.startsWith("{", offset)) {
            throw new IllegalArgumentException("invalid text: '" + text + "'");
        }
        StringBuilder sb = new StringBuilder("{");
        int len = text.length();
        if (len < 2) {
            throw new IllegalArgumentException("invalid text: '" + text + "'");
        }
        int im = 0;
        for (int i = offset + 1; i < len; ++i) {
            char ch = text.charAt(i);
            sb.append(ch);
            if (ch == '{') {
                ++im;
                continue;
            }
            if (ch != '}') continue;
            if (im == 0) {
                return sb.toString();
            }
            --im;
        }
        throw new IllegalArgumentException("invalid text: '" + text + "'");
    }
}

