/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xipki.common.util.ParamUtil;

public class ConfPairs {
    public static final char NAME_TERM = '=';
    public static final char TOKEN_TERM = ',';
    private final Map<String, String> pairs = new HashMap<String, String>();

    public ConfPairs(String name, String value) {
        this.putPair(name, value);
    }

    public ConfPairs() {
    }

    public ConfPairs(String confPairs) {
        ParamUtil.requireNonBlank("confPairs", confPairs);
        int len = confPairs.length();
        LinkedList<String> tokens = new LinkedList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        int i = 0;
        while (i < len) {
            char ch = confPairs.charAt(i);
            if (',' == ch) {
                if (tokenBuilder.length() > 0) {
                    tokens.add(tokenBuilder.toString());
                }
                tokenBuilder = new StringBuilder();
                ++i;
                continue;
            }
            if ('\\' == ch) {
                if (i == len - 1) {
                    throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                }
                tokenBuilder.append(ch);
                ch = confPairs.charAt(i + 1);
                ++i;
            }
            tokenBuilder.append(ch);
            ++i;
        }
        if (tokenBuilder.length() > 0) {
            tokens.add(tokenBuilder.toString());
        }
        for (String token : tokens) {
            char ch;
            int termPosition = -1;
            len = token.length();
            int i2 = 0;
            while (i2 < len) {
                ch = token.charAt(i2);
                if (ch == '=') {
                    termPosition = i2;
                    break;
                }
                if ('\\' == ch) {
                    if (i2 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                ++i2;
            }
            if (termPosition < 1) {
                throw new IllegalArgumentException("invalid ConfPair '" + token + "'");
            }
            tokenBuilder = new StringBuilder();
            i2 = 0;
            while (i2 < termPosition) {
                ch = token.charAt(i2);
                if ('\\' == ch) {
                    if (i2 == termPosition - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                tokenBuilder.append(ch);
                ++i2;
            }
            String name = tokenBuilder.toString();
            tokenBuilder = new StringBuilder();
            for (int i3 = termPosition + 1; i3 < len; ++i3) {
                char ch2 = token.charAt(i3);
                if ('\\' == ch2) {
                    if (i3 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    ch2 = token.charAt(i3 + 1);
                    ++i3;
                }
                tokenBuilder.append(ch2);
            }
            String value = tokenBuilder.toString();
            this.pairs.put(name, value);
        }
    }

    public void putPair(String name, String value) {
        ParamUtil.requireNonBlank("name", name);
        ParamUtil.requireNonNull("value", value);
        char ch = name.charAt(0);
        if (ch >= '0' && ch <= '9') {
            throw new IllegalArgumentException("name begin with " + ch);
        }
        this.pairs.put(name, value);
    }

    public void removePair(String name) {
        ParamUtil.requireNonNull("name", name);
        this.pairs.remove(name);
    }

    public String value(String name) {
        ParamUtil.requireNonNull("name", name);
        return this.pairs.get(name);
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.pairs.keySet());
    }

    public String getEncoded() {
        String value;
        StringBuilder sb = new StringBuilder();
        LinkedList<String> names = new LinkedList<String>();
        for (String name : this.pairs.keySet()) {
            value = this.pairs.get(name);
            if (value.length() > 100) continue;
            names.add(name);
        }
        Collections.sort(names);
        for (String name : this.pairs.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            value = this.pairs.get(name);
            sb.append(ConfPairs.encodeNameOrValue(name));
            sb.append('=');
            sb.append(value == null ? "" : ConfPairs.encodeNameOrValue(value));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public int hashCode() {
        return this.getEncoded().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfPairs)) {
            return false;
        }
        ConfPairs cp = (ConfPairs)obj;
        return this.pairs.equals(cp.pairs);
    }

    private static String encodeNameOrValue(String str) {
        if (str.indexOf(61) == -1 && str.indexOf(44) == -1) {
            return str;
        }
        int n = str.length();
        StringBuilder sb = new StringBuilder(n + 1);
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '=' || ch == ',') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

