/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.common;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;

public abstract class ASN1Type {
    public abstract int encodedLength();

    public abstract int write(byte[] var1, int var2);

    public static int getLen(int bodyLen) {
        return ASN1Type.getHeaderLen(bodyLen) + bodyLen;
    }

    public static int getHeaderLen(int bodyLen) {
        if (bodyLen <= 127) {
            return 2;
        }
        if (bodyLen <= 255) {
            return 3;
        }
        if (bodyLen <= 65535) {
            return 4;
        }
        if (bodyLen <= 0xFFFFFF) {
            return 5;
        }
        return 6;
    }

    public static int writeHeader(byte tag, int bodyLen, byte[] out, int offset) {
        int idx = offset;
        out[idx++] = tag;
        if (bodyLen <= 127) {
            out[idx++] = (byte)bodyLen;
        } else if (bodyLen <= 255) {
            out[idx++] = -127;
            out[idx++] = (byte)bodyLen;
        } else if (bodyLen <= 65535) {
            out[idx++] = -126;
            out[idx++] = (byte)(bodyLen >> 8);
            out[idx++] = (byte)(0xFF & bodyLen);
        } else if (bodyLen <= 0xFFFFFF) {
            out[idx++] = -125;
            out[idx++] = (byte)(0xFF & bodyLen >> 16);
            out[idx++] = (byte)(0xFF & bodyLen >> 8);
            out[idx++] = (byte)(0xFF & bodyLen);
        } else {
            out[idx++] = -124;
            out[idx++] = (byte)(0xFF & bodyLen >> 24);
            out[idx++] = (byte)(0xFF & bodyLen >> 16);
            out[idx++] = (byte)(0xFF & bodyLen >> 8);
            out[idx++] = (byte)(0xFF & bodyLen);
        }
        return idx - offset;
    }

    public static int writeGeneralizedTime(Date time, byte[] out, int offset) {
        OffsetDateTime offsetTime = time.toInstant().atOffset(ZoneOffset.UTC);
        int idx = offset;
        out[idx++] = 24;
        out[idx++] = 15;
        int year = offsetTime.getYear();
        out[idx++] = (byte)(48 + year / 1000);
        out[idx++] = (byte)(48 + year / 100 % 10);
        out[idx++] = (byte)(48 + year / 10 % 10);
        out[idx++] = (byte)(48 + year % 10);
        int month = offsetTime.getMonthValue();
        out[idx++] = (byte)(48 + month / 10);
        out[idx++] = (byte)(48 + month % 10);
        int day = offsetTime.getDayOfMonth();
        out[idx++] = (byte)(48 + day / 10);
        out[idx++] = (byte)(48 + day % 10);
        int hour = offsetTime.getHour();
        out[idx++] = (byte)(48 + hour / 10);
        out[idx++] = (byte)(48 + hour % 10);
        int minute = offsetTime.getMinute();
        out[idx++] = (byte)(48 + minute / 10);
        out[idx++] = (byte)(48 + minute % 10);
        int second = offsetTime.getSecond();
        out[idx++] = (byte)(48 + second / 10);
        out[idx++] = (byte)(48 + second % 10);
        out[idx++] = 90;
        return idx - offset;
    }

    public static int arraycopy(byte[] src, byte[] dest, int destPos) {
        int length = src.length;
        System.arraycopy(src, 0, dest, destPos, length);
        return length;
    }
}

