/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.password.OBFPasswordService;
import org.xipki.security.shell.Actions;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class PasswordActions {

    @Command(scope="xi", name="pbe-enc", description="encrypt password with master password")
    @Service
    public static class PbeEnc
    extends Actions.SecurityAction {
        @Option(name="--out", description="where to save the encrypted password")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="-k", description="quorum of the password parts")
        private Integer quorum = 1;

        protected Object execute0() throws Exception {
            char[] password;
            Args.range((int)this.quorum, (String)"k", (int)1, (int)10);
            if (this.quorum == 1) {
                password = this.readPassword("Password");
            } else {
                char[][] parts = new char[this.quorum.intValue()][];
                for (int i = 0; i < this.quorum; ++i) {
                    parts[i] = this.readPassword("Password (part " + (i + 1) + "/" + this.quorum + ")");
                }
                password = StringUtil.merge((char[][])parts);
            }
            String passwordHint = this.passwordResolver.protectPassword("PBE", password);
            if (this.outFile != null) {
                this.saveVerbose("saved the encrypted password to file", this.outFile, StringUtil.toUtf8Bytes((String)passwordHint));
            } else {
                this.println("the encrypted password is: '" + passwordHint + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="pbe-dec", description="decrypt password with master password")
    @Service
    public static class PbeDec
    extends Actions.SecurityAction {
        @Option(name="--password", description="encrypted password, starts with PBE:\nexactly one of password and password-file must be specified")
        private String passwordHint;
        @Option(name="--password-file", description="file containing the encrypted password")
        @Completion(value=FileCompleter.class)
        private String passwordFile;
        @Option(name="--out", description="where to save the password")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            if (this.passwordHint == null == (this.passwordFile == null)) {
                throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
            }
            if (this.passwordHint == null) {
                this.passwordHint = StringUtil.toUtf8String((byte[])IoUtil.read((String)this.passwordFile));
            }
            if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"PBE:")) {
                throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with PBE:");
            }
            char[] password = this.passwordResolver.resolvePassword(this.passwordHint);
            if (this.outFile != null) {
                this.saveVerbose("saved the password to file", this.outFile, StringUtil.toUtf8Bytes((String)new String(password)));
            } else {
                this.println("the password is: '" + new String(password) + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="obfuscate", description="obfuscate password")
    @Service
    public static class Obfuscate
    extends Actions.SecurityAction {
        @Option(name="--out", description="where to save the encrypted password")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="-k", description="quorum of the password parts")
        private Integer quorum = 1;

        protected Object execute0() throws Exception {
            char[] password;
            Args.range((int)this.quorum, (String)"k", (int)1, (int)10);
            if (this.quorum == 1) {
                password = this.readPassword("Password");
            } else {
                char[][] parts = new char[this.quorum.intValue()][];
                for (int i = 0; i < this.quorum; ++i) {
                    parts[i] = this.readPassword("Password " + (i + 1) + "/" + this.quorum);
                }
                password = StringUtil.merge((char[][])parts);
            }
            String passwordHint = OBFPasswordService.obfuscate((String)new String(password));
            if (this.outFile != null) {
                this.saveVerbose("saved the obfuscated password to file", this.outFile, StringUtil.toUtf8Bytes((String)passwordHint));
            } else {
                this.println("the obfuscated password is: '" + passwordHint + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="deobfuscate", description="deobfuscate password")
    @Service
    public static class Deobfuscate
    extends Actions.SecurityAction {
        @Option(name="--password", description="obfuscated password, starts with OBF:\nexactly one of password and password-file must be specified")
        private String passwordHint;
        @Option(name="--password-file", description="file containing the obfuscated password")
        @Completion(value=FileCompleter.class)
        private String passwordFile;
        @Option(name="--out", description="where to save the password")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            if (this.passwordHint == null == (this.passwordFile == null)) {
                throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
            }
            if (this.passwordHint == null) {
                this.passwordHint = StringUtil.toUtf8String((byte[])IoUtil.read((String)this.passwordFile));
            }
            if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"OBF:")) {
                throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with OBF:");
            }
            String password = OBFPasswordService.deobfuscate((String)this.passwordHint);
            if (this.outFile != null) {
                this.saveVerbose("saved the password to file", this.outFile, StringUtil.toUtf8Bytes((String)password));
            } else {
                this.println("the password is: '" + password + "'");
            }
            return null;
        }
    }
}

