/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class ObjectIdentifiers {
    private static final ASN1ObjectIdentifier id_pen = new ASN1ObjectIdentifier("1.3.6.2.4.1");
    private static final ASN1ObjectIdentifier id_xipki = id_pen.branch("45522");
    private static final ASN1ObjectIdentifier id_xipki_ext = id_xipki.branch("1");
    public static final ASN1ObjectIdentifier id_xipki_ext_crlCertset = id_xipki_ext.branch("1");
    public static final ASN1ObjectIdentifier id_xipki_ext_cmpRequestExtensions = id_xipki_ext.branch("2");
    public static final ASN1ObjectIdentifier id_xipki_ext_authorizationTemplate = id_xipki_ext.branch("3");
    private static final ASN1ObjectIdentifier id_xipki_cmp = id_xipki.branch("2");
    public static final ASN1ObjectIdentifier id_xipki_cmp_cmpGenmsg = id_xipki_cmp.branch("1");
    public static final ASN1ObjectIdentifier id_xipki_cmp_cacerts = id_xipki_cmp.branch("2");
    public static final ASN1ObjectIdentifier DN_C = new ASN1ObjectIdentifier("2.5.4.6");
    public static final ASN1ObjectIdentifier DN_O = new ASN1ObjectIdentifier("2.5.4.10");
    public static final ASN1ObjectIdentifier DN_organizationIdentifier = new ASN1ObjectIdentifier("2.5.4.97");
    public static final ASN1ObjectIdentifier DN_OU = new ASN1ObjectIdentifier("2.5.4.11");
    public static final ASN1ObjectIdentifier DN_T = new ASN1ObjectIdentifier("2.5.4.12");
    public static final ASN1ObjectIdentifier DN_CN = new ASN1ObjectIdentifier("2.5.4.3");
    public static final ASN1ObjectIdentifier DN_SN = new ASN1ObjectIdentifier("2.5.4.5");
    public static final ASN1ObjectIdentifier DN_STREET = new ASN1ObjectIdentifier("2.5.4.9");
    public static final ASN1ObjectIdentifier DN_SERIALNUMBER = DN_SN;
    public static final ASN1ObjectIdentifier DN_L;
    public static final ASN1ObjectIdentifier DN_LOCALITYNAME;
    public static final ASN1ObjectIdentifier DN_ST;
    public static final ASN1ObjectIdentifier DN_SURNAME;
    public static final ASN1ObjectIdentifier DN_GIVENNAME;
    public static final ASN1ObjectIdentifier DN_INITIALS;
    public static final ASN1ObjectIdentifier DN_GENERATION;
    public static final ASN1ObjectIdentifier DN_GENERATION_QUALIFIER;
    public static final ASN1ObjectIdentifier DN_UNIQUE_IDENTIFIER;
    public static final ASN1ObjectIdentifier DN_BUSINESS_CATEGORY;
    public static final ASN1ObjectIdentifier DN_POSTAL_CODE;
    public static final ASN1ObjectIdentifier DN_QUALIFIER;
    public static final ASN1ObjectIdentifier DN_PSEUDONYM;
    public static final ASN1ObjectIdentifier DN_DATE_OF_BIRTH;
    public static final ASN1ObjectIdentifier DN_PLACE_OF_BIRTH;
    public static final ASN1ObjectIdentifier DN_GENDER;
    public static final ASN1ObjectIdentifier DN_COUNTRY_OF_CITIZENSHIP;
    public static final ASN1ObjectIdentifier DN_COUNTRY_OF_RESIDENCE;
    public static final ASN1ObjectIdentifier DN_NAME_AT_BIRTH;
    public static final ASN1ObjectIdentifier DN_POSTAL_ADDRESS;
    public static final ASN1ObjectIdentifier DN_DMD_NAME;
    public static final ASN1ObjectIdentifier DN_TELEPHONE_NUMBER;
    public static final ASN1ObjectIdentifier DN_NAME;
    public static final ASN1ObjectIdentifier DN_EmailAddress;
    public static final ASN1ObjectIdentifier DN_UnstructuredName;
    public static final ASN1ObjectIdentifier DN_UnstructuredAddress;
    public static final ASN1ObjectIdentifier DN_E;
    public static final ASN1ObjectIdentifier DN_DC;
    public static final ASN1ObjectIdentifier DN_LDAP_UID;
    private static final ASN1ObjectIdentifier id_pkix;
    private static final ASN1ObjectIdentifier id_kp;
    public static final ASN1ObjectIdentifier id_anyExtendedKeyUsage;
    public static final ASN1ObjectIdentifier id_kp_serverAuth;
    public static final ASN1ObjectIdentifier id_kp_clientAuth;
    public static final ASN1ObjectIdentifier id_kp_codeSigning;
    public static final ASN1ObjectIdentifier id_kp_emailProtection;
    public static final ASN1ObjectIdentifier id_kp_timeStamping;
    public static final ASN1ObjectIdentifier id_kp_OCSPSigning;
    public static final ASN1ObjectIdentifier id_kp_ipsecEndSystem;
    public static final ASN1ObjectIdentifier id_kp_ipsecTunnel;
    public static final ASN1ObjectIdentifier id_kp_ipsecUser;
    public static final ASN1ObjectIdentifier id_pkix_ocsp_prefSigAlgs;
    public static final ASN1ObjectIdentifier id_pkix_ocsp_extendedRevoke;
    public static final ASN1ObjectIdentifier id_tsl_kp_tslSigning;
    public static final ASN1ObjectIdentifier id_kp_ocsp;
    public static final ASN1ObjectIdentifier id_extension_pkix_ocsp_nocheck;
    public static final ASN1ObjectIdentifier id_extension_restriction;
    public static final ASN1ObjectIdentifier id_extension_additionalInformation;
    public static final ASN1ObjectIdentifier id_extension_validityModel;
    public static final ASN1ObjectIdentifier id_extension_admission;
    private static final ASN1ObjectIdentifier id_ad;
    public static final ASN1ObjectIdentifier id_ad_timeStamping;
    public static final ASN1ObjectIdentifier id_ad_caRepository;
    private static final ASN1ObjectIdentifier id_qcs;
    public static final ASN1ObjectIdentifier id_qcs_pkixQCSyntax_v1;
    public static final ASN1ObjectIdentifier id_qcs_pkixQCSyntax_v2;
    private static final ASN1ObjectIdentifier id_etsi_qcs;
    public static final ASN1ObjectIdentifier id_etsi_qcs_QcCompliance;
    public static final ASN1ObjectIdentifier id_etsi_qcs_QcLimitValue;
    public static final ASN1ObjectIdentifier id_etsi_qcs_QcRetentionPeriod;
    public static final ASN1ObjectIdentifier id_etsi_qcs_QcSSCD;
    public static final ASN1ObjectIdentifier id_etsi_qcs_QcPDS;
    private static final ASN1ObjectIdentifier id_pe;
    public static final ASN1ObjectIdentifier id_pe_tlsfeature;
    private static final ASN1ObjectIdentifier id_secg_scheme;
    public static final ASN1ObjectIdentifier id_aes128_cbc_in_ecies;
    public static final ASN1ObjectIdentifier id_ecies_specifiedParameters;
    public static final ASN1ObjectIdentifier id_hmac_full_ecies;
    public static final ASN1ObjectIdentifier id_iso18033_kdf2;
    private static final Map<ASN1ObjectIdentifier, String> oidNameMap;
    public static final ASN1ObjectIdentifier id_smimeCapabilities;

    private ObjectIdentifiers() {
    }

    public static String oidToDisplayName(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        String name = ObjectIdentifiers.getName(type);
        return name == null ? type.getId() : type.getId() + " (" + name + ")";
    }

    public static String getName(ASN1ObjectIdentifier type) {
        ParamUtil.requireNonNull((String)"type", (Object)type);
        String name = oidNameMap.get(type);
        if (StringUtil.isBlank((String)name)) {
            try {
                name = RFC4519Style.INSTANCE.oidToDisplayName(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return name;
    }

    public static ASN1ObjectIdentifier nameToOid(String name) {
        ParamUtil.requireNonNull((String)"name", (Object)name);
        for (ASN1ObjectIdentifier oid : oidNameMap.keySet()) {
            if (!oidNameMap.get(oid).equalsIgnoreCase(name)) continue;
            return oid;
        }
        try {
            return RFC4519Style.INSTANCE.attrNameToOID(name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    static {
        DN_LOCALITYNAME = DN_L = new ASN1ObjectIdentifier("2.5.4.7");
        DN_ST = new ASN1ObjectIdentifier("2.5.4.8");
        DN_SURNAME = new ASN1ObjectIdentifier("2.5.4.4");
        DN_GIVENNAME = new ASN1ObjectIdentifier("2.5.4.42");
        DN_INITIALS = new ASN1ObjectIdentifier("2.5.4.43");
        DN_GENERATION_QUALIFIER = DN_GENERATION = new ASN1ObjectIdentifier("2.5.4.44");
        DN_UNIQUE_IDENTIFIER = new ASN1ObjectIdentifier("2.5.4.45");
        DN_BUSINESS_CATEGORY = new ASN1ObjectIdentifier("2.5.4.15");
        DN_POSTAL_CODE = new ASN1ObjectIdentifier("2.5.4.17");
        DN_QUALIFIER = new ASN1ObjectIdentifier("2.5.4.46");
        DN_PSEUDONYM = new ASN1ObjectIdentifier("2.5.4.65");
        DN_DATE_OF_BIRTH = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1");
        DN_PLACE_OF_BIRTH = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.2");
        DN_GENDER = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.3");
        DN_COUNTRY_OF_CITIZENSHIP = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.4");
        DN_COUNTRY_OF_RESIDENCE = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.5");
        DN_NAME_AT_BIRTH = new ASN1ObjectIdentifier("1.3.36.8.3.14");
        DN_POSTAL_ADDRESS = new ASN1ObjectIdentifier("2.5.4.16");
        DN_DMD_NAME = new ASN1ObjectIdentifier("2.5.4.54");
        DN_TELEPHONE_NUMBER = X509ObjectIdentifiers.id_at_telephoneNumber;
        DN_NAME = X509ObjectIdentifiers.id_at_name;
        DN_EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
        DN_UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
        DN_UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
        DN_E = DN_EmailAddress;
        DN_DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
        DN_LDAP_UID = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
        id_pkix = new ASN1ObjectIdentifier("1.3.6.1.5.5.7");
        id_kp = id_pkix.branch("3");
        id_anyExtendedKeyUsage = Extension.extendedKeyUsage.branch("0");
        id_kp_serverAuth = id_kp.branch("1");
        id_kp_clientAuth = id_kp.branch("2");
        id_kp_codeSigning = id_kp.branch("3");
        id_kp_emailProtection = id_kp.branch("4");
        id_kp_timeStamping = id_kp.branch("8");
        id_kp_OCSPSigning = id_kp.branch("9");
        id_kp_ipsecEndSystem = id_kp.branch("5");
        id_kp_ipsecTunnel = id_kp.branch("6");
        id_kp_ipsecUser = id_kp.branch("7");
        id_pkix_ocsp_prefSigAlgs = OCSPObjectIdentifiers.id_pkix_ocsp.branch("8");
        id_pkix_ocsp_extendedRevoke = OCSPObjectIdentifiers.id_pkix_ocsp.branch("9");
        id_tsl_kp_tslSigning = new ASN1ObjectIdentifier("0.4.0.2231.3.0");
        id_kp_ocsp = id_pkix.branch("1.48.1");
        id_extension_pkix_ocsp_nocheck = id_pkix.branch("48.1.5");
        id_extension_restriction = new ASN1ObjectIdentifier("1.3.36.8.3.8");
        id_extension_additionalInformation = new ASN1ObjectIdentifier("1.3.36.8.3.15");
        id_extension_validityModel = new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.5");
        id_extension_admission = new ASN1ObjectIdentifier("1.3.36.8.3.3");
        id_ad = id_pkix.branch("48");
        id_ad_timeStamping = id_ad.branch("3");
        id_ad_caRepository = id_ad.branch("5");
        id_qcs = id_pkix.branch("11");
        id_qcs_pkixQCSyntax_v1 = id_qcs.branch("1");
        id_qcs_pkixQCSyntax_v2 = id_qcs.branch("2");
        id_etsi_qcs = new ASN1ObjectIdentifier("0.4.0.1862.1");
        id_etsi_qcs_QcCompliance = id_etsi_qcs.branch("1");
        id_etsi_qcs_QcLimitValue = id_etsi_qcs.branch("2");
        id_etsi_qcs_QcRetentionPeriod = id_etsi_qcs.branch("3");
        id_etsi_qcs_QcSSCD = id_etsi_qcs.branch("4");
        id_etsi_qcs_QcPDS = id_etsi_qcs.branch("5");
        id_pe = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1");
        id_pe_tlsfeature = id_pe.branch("24");
        id_secg_scheme = new ASN1ObjectIdentifier("1.3.132.1");
        id_aes128_cbc_in_ecies = id_secg_scheme.branch("20.0");
        id_ecies_specifiedParameters = id_secg_scheme.branch("8");
        id_hmac_full_ecies = id_secg_scheme.branch("22");
        id_iso18033_kdf2 = new ASN1ObjectIdentifier("1.0.18033.2.5.2");
        id_smimeCapabilities = new ASN1ObjectIdentifier("1.2.840.113549.1.9.15");
        oidNameMap = new HashMap<ASN1ObjectIdentifier, String>();
        oidNameMap.put(DN_DATE_OF_BIRTH, "dateOfBirth");
        oidNameMap.put(DN_PLACE_OF_BIRTH, "placeOfBirth");
        oidNameMap.put(DN_GENDER, "gender");
        oidNameMap.put(DN_COUNTRY_OF_CITIZENSHIP, "countryOfCitizenship");
        oidNameMap.put(DN_COUNTRY_OF_RESIDENCE, "countryOfResidence");
        oidNameMap.put(DN_NAME_AT_BIRTH, "nameAtBirth");
        oidNameMap.put(DN_PSEUDONYM, "pseudonym");
        oidNameMap.put(DN_DMD_NAME, "dmdName");
        oidNameMap.put(DN_EmailAddress, "emailAddress");
        oidNameMap.put(DN_UnstructuredName, "unstructuredName");
        oidNameMap.put(DN_UnstructuredAddress, "unstructuredAddress");
        oidNameMap.put(DN_organizationIdentifier, "organizationIdentifier");
        oidNameMap.put(id_xipki_ext_crlCertset, "xipki-crlCertset");
        oidNameMap.put(id_xipki_ext_cmpRequestExtensions, "xipki-cmpRequestExtensions");
        oidNameMap.put(id_xipki_ext_authorizationTemplate, "xipki-authorizationTemplate");
        oidNameMap.put(id_kp_clientAuth, "kp-clientAuth");
        oidNameMap.put(id_kp_codeSigning, "kp-codeSigning");
        oidNameMap.put(id_kp_emailProtection, "kp-emailProtection");
        oidNameMap.put(id_kp_ipsecEndSystem, "kp-ipsecEndSystem");
        oidNameMap.put(id_kp_ipsecTunnel, "kp-ipsecTunnel");
        oidNameMap.put(id_kp_ipsecUser, "kp-ipsecUser");
        oidNameMap.put(id_kp_ocsp, "kp-ocsp");
        oidNameMap.put(id_kp_OCSPSigning, "kp-OCSPSigning");
        oidNameMap.put(id_kp_serverAuth, "kp-serverAuth");
        oidNameMap.put(id_kp_timeStamping, "kp-timeStamping");
        oidNameMap.put(id_pkix_ocsp_extendedRevoke, "pkix-ocsp-extendedRevoke");
        oidNameMap.put(id_pkix_ocsp_prefSigAlgs, "pkix-ocsp-prefSigAlgs");
        oidNameMap.put(id_tsl_kp_tslSigning, "tsl-kp-tslSigning");
        oidNameMap.put(id_extension_pkix_ocsp_nocheck, "pkix-ocsp-nocheck");
        oidNameMap.put(id_extension_restriction, "restriction");
        oidNameMap.put(id_extension_additionalInformation, "additionalInformation");
        oidNameMap.put(id_extension_admission, "admission");
        oidNameMap.put(id_extension_validityModel, "validityModel");
        oidNameMap.put(id_anyExtendedKeyUsage, "anyExtendedKeyUsage");
        oidNameMap.put(id_ad_caRepository, "ad-caRepository");
        oidNameMap.put(id_ad_timeStamping, "ad-timeStamping");
        oidNameMap.put(Extension.auditIdentity, "auditIdentity");
        oidNameMap.put(Extension.authorityInfoAccess, "authorityInfoAccess");
        oidNameMap.put(Extension.authorityKeyIdentifier, "authorityKeyIdentifier");
        oidNameMap.put(Extension.basicConstraints, "basicConstraints");
        oidNameMap.put(Extension.biometricInfo, "biometricInfo");
        oidNameMap.put(Extension.certificateIssuer, "certificateIssuer");
        oidNameMap.put(Extension.certificatePolicies, "certificatePolicies");
        oidNameMap.put(Extension.cRLDistributionPoints, "cRLDistributionPoints");
        oidNameMap.put(Extension.cRLNumber, "cRLNumber");
        oidNameMap.put(Extension.deltaCRLIndicator, "deltaCRLIndicator");
        oidNameMap.put(Extension.extendedKeyUsage, "extendedKeyUsage");
        oidNameMap.put(Extension.freshestCRL, "freshestCRL");
        oidNameMap.put(Extension.inhibitAnyPolicy, "inhibitAnyPolicy");
        oidNameMap.put(Extension.instructionCode, "instructionCode");
        oidNameMap.put(Extension.invalidityDate, "invalidityDate");
        oidNameMap.put(Extension.issuerAlternativeName, "issuerAlternativeName");
        oidNameMap.put(Extension.issuingDistributionPoint, "issuingDistributionPoint");
        oidNameMap.put(Extension.keyUsage, "keyUsage");
        oidNameMap.put(Extension.logoType, "logoType");
        oidNameMap.put(Extension.nameConstraints, "nameConstraints");
        oidNameMap.put(Extension.noRevAvail, "noRevAvail");
        oidNameMap.put(Extension.policyConstraints, "policyConstraints");
        oidNameMap.put(Extension.policyMappings, "policyMappings");
        oidNameMap.put(Extension.privateKeyUsagePeriod, "privateKeyUsagePeriod");
        oidNameMap.put(Extension.qCStatements, "qCStatements");
        oidNameMap.put(Extension.reasonCode, "reasonCode");
        oidNameMap.put(Extension.subjectAlternativeName, "subjectAlternativeName");
        oidNameMap.put(Extension.subjectDirectoryAttributes, "subjectDirectoryAttributes");
        oidNameMap.put(Extension.subjectInfoAccess, "subjectInfoAccess");
        oidNameMap.put(Extension.subjectKeyIdentifier, "subjectKeyIdentifier");
        oidNameMap.put(Extension.targetInformation, "targetInformation");
        oidNameMap.put(id_qcs_pkixQCSyntax_v1, "qcs-pkixQCSyntax-v2");
        oidNameMap.put(id_qcs_pkixQCSyntax_v2, "qcs-pkixQCSyntax-v2");
        oidNameMap.put(id_etsi_qcs_QcCompliance, "etsi-qcs-QcCompliance");
        oidNameMap.put(id_etsi_qcs_QcLimitValue, "etsi-qcs-QcLimitValue");
        oidNameMap.put(id_etsi_qcs_QcRetentionPeriod, "etsi-qcs-QcRetentionPeriod");
        oidNameMap.put(id_etsi_qcs_QcSSCD, "etsi-qcs-QcSSCD");
        oidNameMap.put(id_pe_tlsfeature, "tlsFeature");
        oidNameMap.put(id_smimeCapabilities, "SMIMECapatibilities");
        oidNameMap.put(id_aes128_cbc_in_ecies, "aes128-cbc-in-ecies");
        oidNameMap.put(id_ecies_specifiedParameters, "ecies-specifiedParameters");
        oidNameMap.put(id_hmac_full_ecies, "hmac-full-ecies");
        oidNameMap.put(id_iso18033_kdf2, "kdf2");
    }
}

