/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import org.xipki.util.ParamUtil;

public enum KeyUsage {
    digitalSignature(0, 128, "digitalSignature"),
    contentCommitment(1, 64, "contentCommitment", "nonRepudiation"),
    keyEncipherment(2, 32, "keyEncipherment"),
    dataEncipherment(3, 16, "dataEncipherment"),
    keyAgreement(4, 8, "keyAgreement"),
    keyCertSign(5, 4, "keyCertSign"),
    cRLSign(6, 2, "cRLSign"),
    encipherOnly(7, 1, "encipherOnly"),
    decipherOnly(8, 32768, "decipherOnly");

    private int bit;
    private int bcUsage;
    private String[] names;

    private KeyUsage(int bit, int bcUsage, String ... names) {
        this.bit = bit;
        this.bcUsage = bcUsage;
        this.names = names;
    }

    public int getBit() {
        return this.bit;
    }

    public int getBcUsage() {
        return this.bcUsage;
    }

    public String getName() {
        return this.names[0];
    }

    public static KeyUsage getKeyUsage(String usage) {
        ParamUtil.requireNonNull((String)"usage", (Object)usage);
        for (KeyUsage ku : KeyUsage.values()) {
            for (String name : ku.names) {
                if (!name.equals(usage)) continue;
                return ku;
            }
        }
        throw new IllegalArgumentException("invalid KeyUsage " + usage);
    }

    public static KeyUsage getKeyUsage(int bit) {
        for (KeyUsage ku : KeyUsage.values()) {
            if (ku.bit != bit) continue;
            return ku;
        }
        throw new IllegalArgumentException("invalid KeyUsage(bit) " + bit);
    }

    public static KeyUsage getKeyUsageFromBcUsage(int bcUsage) {
        for (KeyUsage ku : KeyUsage.values()) {
            if (ku.bcUsage != bcUsage) continue;
            return ku;
        }
        throw new IllegalArgumentException("invalid KeyUsage(bcUsage) " + bcUsage);
    }
}

