/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.jscepclient.shell;

import java.io.File;
import java.math.BigInteger;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.jscep.client.Client;
import org.xipki.scep.jscepclient.shell.ClientAction;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.completer.DerPemCompleter;

@Command(scope="xi", name="jscep-getcert", description="download certificate")
@Service
public class GetCertAction
extends ClientAction {
    @Option(name="--serial", aliases={"-s"}, required=true, description="serial number")
    private String serialNumber;
    @Option(name="--outform", description="output format of the certificate")
    @Completion(value=DerPemCompleter.class)
    protected String outform = "der";
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
    @Completion(value=FileCompleter.class)
    private String outputFile;

    protected Object execute0() throws Exception {
        Client client = this.getScepClient();
        BigInteger serial = GetCertAction.toBigInt((String)this.serialNumber);
        CertStore certs = client.getCertificate(this.getIdentityCert(), this.getIdentityKey(), serial, null);
        X509Certificate cert = this.extractEeCerts(certs);
        if (cert == null) {
            throw new CmdFailure("received no certificate from server");
        }
        this.saveVerbose("saved returned certificate to file", new File(this.outputFile), this.derPemEncodeCert(cert.getEncoded(), this.outform));
        return null;
    }
}

