/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import org.xipki.common.ASN1Type;

public class TaggedCertSequence
extends ASN1Type {
    private final byte[] encoded;
    private final int encodedLen;

    public TaggedCertSequence(byte[] encodedCert) {
        this(new byte[][]{encodedCert});
    }

    public TaggedCertSequence(byte[][] encodedCerts) {
        int seqBodyLen = 0;
        for (int i = 0; i < encodedCerts.length; ++i) {
            seqBodyLen += encodedCerts[i].length;
        }
        int seqLen = TaggedCertSequence.getLen((int)seqBodyLen);
        this.encodedLen = TaggedCertSequence.getLen((int)seqLen);
        this.encoded = new byte[this.encodedLen];
        int idx = 0;
        idx += TaggedCertSequence.writeHeader((byte)-96, (int)seqLen, (byte[])this.encoded, (int)idx);
        idx += TaggedCertSequence.writeHeader((byte)48, (int)seqBodyLen, (byte[])this.encoded, (int)idx);
        for (int i = 0; i < encodedCerts.length; ++i) {
            idx += TaggedCertSequence.arraycopy((byte[])encodedCerts[i], (byte[])this.encoded, (int)idx);
        }
    }

    public int encodedLength() {
        return this.encodedLen;
    }

    public int write(byte[] out, int offset) {
        return TaggedCertSequence.arraycopy((byte[])this.encoded, (byte[])out, (int)offset);
    }
}

