/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.ocsp.TBSRequest;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.impl.type.CertID;
import org.xipki.ocsp.server.impl.type.EncodingException;
import org.xipki.ocsp.server.impl.type.ExtendedExtension;

public class OcspRequest {
    private final int version;
    private final List<ExtendedExtension> extensions;
    private final List<CertID> requestList;

    public OcspRequest(int version, List<CertID> requestList, List<ExtendedExtension> extensions) {
        this.version = version;
        this.requestList = requestList;
        this.extensions = extensions;
    }

    public static OcspRequest getInstance(byte[] request) throws EncodingException {
        Header hdr = OcspRequest.readHeader(request, 0);
        Header hdrTbs = OcspRequest.readHeader(request, hdr.readerIndex);
        int version = 0;
        hdr = OcspRequest.readHeader(request, hdrTbs.readerIndex);
        boolean tagged = (hdr.tag & 0x80) != 0;
        int tag = hdr.tag & 0x1F;
        if (tagged) {
            if (tag == 0) {
                Header hdr0 = OcspRequest.readHeader(request, hdr.readerIndex);
                if (hdr0.len == 1) {
                    version = 0xFF & request[hdr0.readerIndex];
                } else {
                    throw new EncodingException("version too large");
                }
            }
            while ((hdr.tag & 0x80) != 0) {
                hdr = OcspRequest.readHeader(request, hdr.readerIndex + hdr.len);
            }
        }
        LinkedList<CertID> requestList = new LinkedList<CertID>();
        Header hdrRequestList = hdr;
        Header hdrSingleReq = OcspRequest.readHeader(request, hdr.readerIndex);
        while (true) {
            Header hdrCertId = OcspRequest.readHeader(request, hdrSingleReq.readerIndex);
            Header hdrHashAlgo = OcspRequest.readHeader(request, hdrCertId.readerIndex);
            Header hdrNameHash = OcspRequest.readHeader(request, hdrHashAlgo.readerIndex + hdrHashAlgo.len);
            Header hdrKeyHash = OcspRequest.readHeader(request, hdrNameHash.readerIndex + hdrNameHash.len);
            Header hdrSerial = OcspRequest.readHeader(request, hdrKeyHash.readerIndex + hdrKeyHash.len);
            RequestIssuer issuer = new RequestIssuer(request, hdrCertId.readerIndex, hdrKeyHash.readerIndex + hdrKeyHash.len - hdrCertId.readerIndex);
            BigInteger serialNumber = new BigInteger(OcspRequest.readContent(request, hdrSerial));
            CertID certId = new CertID(issuer, serialNumber);
            requestList.add(certId);
            int nextIndex = hdrSingleReq.readerIndex + hdrSingleReq.len;
            if (nextIndex >= hdrRequestList.readerIndex + hdrRequestList.len) break;
            hdrSingleReq = OcspRequest.readHeader(request, nextIndex);
        }
        LinkedList<ExtendedExtension> extensions = new LinkedList<ExtendedExtension>();
        int extensionsOffset = hdrRequestList.readerIndex + hdrRequestList.len;
        if (extensionsOffset < hdrTbs.readerIndex + hdrTbs.len) {
            hdr = OcspRequest.readHeader(request, extensionsOffset);
            tag = hdr.tag;
            if ((tag & 0x80) == 0 || (tag & 0x1F) != 2) {
                throw new EncodingException("invalid element after requestList");
            }
            Header hdrExtensions = OcspRequest.readHeader(request, hdr.readerIndex);
            Header hdrExtension = OcspRequest.readHeader(request, hdrExtensions.readerIndex);
            while (true) {
                int nextIndex;
                int extensionLen;
                ExtendedExtension extn;
                if ((extn = ExtendedExtension.getInstance(request, hdrExtension.tagIndex, extensionLen = hdrExtension.readerIndex - hdrExtension.tagIndex + hdrExtension.len)) != null) {
                    extensions.add(extn);
                }
                if ((nextIndex = hdrExtension.readerIndex + hdrExtension.len) >= hdrExtensions.readerIndex + hdrExtensions.len) break;
                hdrExtension = OcspRequest.readHeader(request, nextIndex);
            }
        }
        return new OcspRequest(version, requestList, extensions);
    }

    public static OcspRequest getInstance(OCSPRequest req) throws EncodingException {
        TBSRequest tbsReq0 = req.getTbsRequest();
        int version = tbsReq0.getVersion().getValue().intValue();
        Extensions extensions0 = tbsReq0.getRequestExtensions();
        HashSet<String> criticalExtensionOids = new HashSet<String>();
        if (extensions0 != null) {
            for (ASN1ObjectIdentifier oid : extensions0.getCriticalExtensionOIDs()) {
                criticalExtensionOids.add(oid.getId());
            }
        }
        ASN1Sequence requestList0 = tbsReq0.getRequestList();
        int n = requestList0.size();
        ArrayList<CertID> requestList = new ArrayList<CertID>(n);
        for (int i = 0; i < n; ++i) {
            Request singleReq0 = Request.getInstance((Object)requestList0.getObjectAt(i));
            org.bouncycastle.asn1.ocsp.CertID certId0 = singleReq0.getReqCert();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(certId0.getHashAlgorithm().getEncoded());
                out.write(certId0.getIssuerNameHash().getEncoded());
                out.write(certId0.getIssuerKeyHash().getEncoded());
            }
            catch (IOException ex) {
                throw new EncodingException(ex.getMessage(), ex);
            }
            byte[] encodedIssuer = out.toByteArray();
            RequestIssuer issuer = new RequestIssuer(encodedIssuer, 0, encodedIssuer.length);
            CertID certId = new CertID(issuer, certId0.getSerialNumber().getValue());
            requestList.add(certId);
        }
        LinkedList<ExtendedExtension> extensions = new LinkedList<ExtendedExtension>();
        if (extensions0 != null) {
            ASN1ObjectIdentifier[] extOids;
            for (ASN1ObjectIdentifier oid : extOids = extensions0.getExtensionOIDs()) {
                byte[] encoded;
                Extension extension0 = extensions0.getExtension(oid);
                try {
                    encoded = extension0.getEncoded();
                }
                catch (IOException ex) {
                    throw new EncodingException("error encoding Extension", ex);
                }
                extensions.add(ExtendedExtension.getInstance(encoded, 0, encoded.length));
            }
        }
        return new OcspRequest(version, requestList, extensions);
    }

    public static int readRequestVersion(byte[] request) throws EncodingException {
        Header hdr = OcspRequest.readHeader(request, 0);
        hdr = OcspRequest.readHeader(request, hdr.readerIndex);
        hdr = OcspRequest.readHeader(request, hdr.readerIndex);
        if ((hdr.tag & 0x1F) != 0) {
            return 0;
        }
        hdr = OcspRequest.readHeader(request, hdr.readerIndex);
        if (hdr.len == 1) {
            return 0xFF & request[hdr.readerIndex];
        }
        throw new EncodingException("version too large");
    }

    public static boolean containsSignature(byte[] request) throws EncodingException {
        Header hdr = OcspRequest.readHeader(request, 0);
        Header hdrTbs = OcspRequest.readHeader(request, hdr.readerIndex);
        int signatureIndex = hdrTbs.readerIndex + hdrTbs.len;
        return signatureIndex < request.length;
    }

    static Header readHeader(byte[] encoded, int readerIndex) throws EncodingException {
        int len;
        int off = readerIndex;
        byte tag = encoded[off++];
        if ((len = 0xFF & encoded[off++]) >= 128) {
            int lenSize = len & 0x7F;
            if (lenSize == 1) {
                len = 0xFF & encoded[off++];
            } else if (lenSize == 2) {
                len = (0xFF & encoded[off++]) << 8 | 0xFF & encoded[off++];
            } else if (lenSize == 3) {
                len = (0xFF & encoded[off++]) << 16 | (0xFF & encoded[off++]) << 8 | 0xFF & encoded[off++];
            } else if (lenSize == 4) {
                len = (0xFF & encoded[off++]) << 24 | (0xFF & encoded[off++]) << 16 | (0xFF & encoded[off++]) << 8 | 0xFF & encoded[off++];
            } else {
                throw new EncodingException("invalid length field at " + readerIndex);
            }
        }
        return new Header(readerIndex, tag, len, off);
    }

    private static byte[] readContent(byte[] encoded, Header header) {
        byte[] content = new byte[header.len];
        System.arraycopy(encoded, header.readerIndex, content, 0, header.len);
        return content;
    }

    public int version() {
        return this.version;
    }

    public List<CertID> requestList() {
        return this.requestList;
    }

    public List<ExtendedExtension> extensions() {
        return this.extensions;
    }

    static class Header {
        int tagIndex;
        byte tag;
        int len;
        int readerIndex;

        Header(int tagIndex, byte tag, int len, int readerIndex) {
            this.tagIndex = tagIndex;
            this.tag = tag;
            this.len = len;
            this.readerIndex = readerIndex;
        }

        public String toString() {
            return "tag=0x" + Integer.toHexString(0xFF & this.tag) + ", len=" + this.len + ", tagIndex=" + this.tagIndex + ", readerIndex=" + this.readerIndex;
        }
    }
}

