/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.util.List;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.server.impl.type.Extension;

public class Extensions
extends ASN1Type {
    private final List<Extension> extensions;
    private final int bodyLen;
    private final int encodedLen;

    public Extensions(List<Extension> extensions) {
        int len = 0;
        for (Extension m : extensions) {
            len += m.encodedLength();
        }
        this.bodyLen = len;
        this.encodedLen = Extensions.getLen((int)this.bodyLen);
        this.extensions = extensions;
    }

    public int encodedLength() {
        return this.encodedLen;
    }

    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += Extensions.writeHeader((byte)48, (int)this.bodyLen, (byte[])out, (int)idx);
        for (Extension m : this.extensions) {
            idx += m.write(out, idx);
        }
        return idx - offset;
    }
}

