/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.db;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.xipki.ocsp.api.OcspStoreException;

class StoreConf {
    private static final String KEY_cacerts_includes = "cacerts.includes";
    private static final String KEY_cacerts_excludes = "cacerts.excludes";
    private final Set<String> caCertsIncludes = new HashSet<String>();
    private final Set<String> caCertsExcludes = new HashSet<String>();

    StoreConf(String propsConf) throws OcspStoreException {
        StringTokenizer st;
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(propsConf.getBytes()));
        }
        catch (IOException ex) {
            throw new OcspStoreException("could not load properties: " + ex.getMessage(), (Throwable)ex);
        }
        String str = props.getProperty(KEY_cacerts_includes);
        if (str != null) {
            st = new StringTokenizer(str, ", ");
            while (st.hasMoreTokens()) {
                this.caCertsIncludes.add(st.nextToken());
            }
        }
        if ((str = props.getProperty(KEY_cacerts_excludes)) != null) {
            st = new StringTokenizer(str, ", ");
            while (st.hasMoreTokens()) {
                this.caCertsExcludes.add(st.nextToken());
            }
        }
    }

    Set<String> caCertsIncludes() {
        return this.caCertsIncludes;
    }

    Set<String> caCertsExcludes() {
        return this.caCertsExcludes;
    }
}

