/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.store.crl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.xipki.common.util.StringUtil;
import org.xipki.ocsp.api.OcspStoreException;

class StoreConf {
    private static final String KEY_crl_file = "crl.file";
    private static final String KEY_crl_url = "crl.url";
    private static final String KEY_useUpdateDatesFromCrl = "useUpdateDatesFromCrl";
    private static final String KEY_caCert_file = "caCert.file";
    private static final String KEY_issuerCert_file = "issuerCert.file";
    private static final String KEY_certs_dir = "certs.dir";
    private String crlFile;
    private String crlUrl;
    private boolean useUpdateDatesFromCrl = true;
    private String caCertFile;
    private String issuerCertFile;
    private String certsDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StoreConf(String propsConf) throws OcspStoreException {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(propsConf.getBytes()));
        }
        catch (IOException ex) {
            throw new OcspStoreException("could not load properties: " + ex.getMessage(), (Throwable)ex);
        }
        this.crlFile = this.getRequiredProperty(props, KEY_crl_file);
        this.crlUrl = this.getOptionalProperty(props, KEY_crl_url);
        this.caCertFile = this.getRequiredProperty(props, KEY_caCert_file);
        this.issuerCertFile = this.getOptionalProperty(props, KEY_issuerCert_file);
        this.certsDir = this.getOptionalProperty(props, KEY_certs_dir);
        String propKey = KEY_useUpdateDatesFromCrl;
        String propValue = props.getProperty(propKey);
        if (propValue != null) {
            if ("true".equalsIgnoreCase(propValue = propValue.trim())) {
                this.useUpdateDatesFromCrl = true;
                return;
            } else {
                if (!"false".equalsIgnoreCase(propValue)) throw new OcspStoreException("invalid property " + propKey + ": '" + propValue + "'");
                this.useUpdateDatesFromCrl = false;
            }
            return;
        } else {
            this.useUpdateDatesFromCrl = true;
        }
    }

    String crlFile() {
        return this.crlFile;
    }

    String crlUrl() {
        return this.crlUrl;
    }

    boolean isUseUpdateDatesFromCrl() {
        return this.useUpdateDatesFromCrl;
    }

    String caCertFile() {
        return this.caCertFile;
    }

    String issuerCertFile() {
        return this.issuerCertFile;
    }

    String certsDir() {
        return this.certsDir;
    }

    private String getRequiredProperty(Properties props, String propKey) throws OcspStoreException {
        String str = props.getProperty(propKey);
        if (str == null) {
            throw new OcspStoreException("missing required property " + propKey);
        }
        String ret = str.trim();
        if (StringUtil.isBlank((String)ret)) {
            throw new OcspStoreException("property " + propKey + " must not be blank");
        }
        return str.trim();
    }

    private String getOptionalProperty(Properties props, String propKey) throws OcspStoreException {
        String str = props.getProperty(propKey);
        if (str == null) {
            return null;
        }
        return str.trim();
    }
}

