/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.HealthCheckResult;
import org.xipki.common.InvalidConfException;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.TripleState;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.common.util.XmlUtil;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.springframework.dao.DataAccessException;
import org.xipki.http.servlet.ServletURI;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspMode;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.OcspStoreFactoryRegister;
import org.xipki.ocsp.server.impl.CertWithEncoded;
import org.xipki.ocsp.server.impl.OCSPRespBuilder;
import org.xipki.ocsp.server.impl.OcspRespWithCacheInfo;
import org.xipki.ocsp.server.impl.OcspResponseStatus;
import org.xipki.ocsp.server.impl.RequestOption;
import org.xipki.ocsp.server.impl.Responder;
import org.xipki.ocsp.server.impl.ResponderOption;
import org.xipki.ocsp.server.impl.ResponderSigner;
import org.xipki.ocsp.server.impl.ResponseCacher;
import org.xipki.ocsp.server.impl.ResponseOption;
import org.xipki.ocsp.server.impl.Template;
import org.xipki.ocsp.server.impl.jaxb.DatasourceType;
import org.xipki.ocsp.server.impl.jaxb.EmbedCertsMode;
import org.xipki.ocsp.server.impl.jaxb.FileOrPlainValueType;
import org.xipki.ocsp.server.impl.jaxb.FileOrValueType;
import org.xipki.ocsp.server.impl.jaxb.OCSPServer;
import org.xipki.ocsp.server.impl.jaxb.ObjectFactory;
import org.xipki.ocsp.server.impl.jaxb.RequestOptionType;
import org.xipki.ocsp.server.impl.jaxb.ResponderType;
import org.xipki.ocsp.server.impl.jaxb.ResponseCacheType;
import org.xipki.ocsp.server.impl.jaxb.ResponseOptionType;
import org.xipki.ocsp.server.impl.jaxb.SignerType;
import org.xipki.ocsp.server.impl.jaxb.StoreType;
import org.xipki.ocsp.server.impl.store.crl.CrlDbCertStatusStore;
import org.xipki.ocsp.server.impl.store.db.DbCertStatusStore;
import org.xipki.ocsp.server.impl.type.CertID;
import org.xipki.ocsp.server.impl.type.EncodingException;
import org.xipki.ocsp.server.impl.type.ExtendedExtension;
import org.xipki.ocsp.server.impl.type.Extension;
import org.xipki.ocsp.server.impl.type.Extensions;
import org.xipki.ocsp.server.impl.type.OID;
import org.xipki.ocsp.server.impl.type.OcspRequest;
import org.xipki.ocsp.server.impl.type.ResponderID;
import org.xipki.ocsp.server.impl.type.TaggedCertSequence;
import org.xipki.ocsp.server.impl.type.WritableOnlyExtension;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.exception.NoIdleSignerException;
import org.xipki.security.util.X509Util;
import org.xml.sax.SAXException;

public class OcspServer {
    public static final long DFLT_CACHE_MAX_AGE = 60L;
    private static final byte[] DERNullBytes = new byte[]{5, 0};
    private static final byte[] bytes_certstatus_good = new byte[]{-128, 0};
    private static final byte[] bytes_certstatus_unknown = new byte[]{-126, 0};
    private static final byte[] bytes_certstatus_rfc6960_unknown = Hex.decode((String)"a116180f31393730303130313030303030305aa0030a0106");
    private static final WritableOnlyExtension extension_pkix_ocsp_extendedRevoke;
    private static final Logger LOG;
    private static final Map<OcspResponseStatus, OcspRespWithCacheInfo> unsuccesfulOCSPRespMap;
    private final DataSourceFactory datasourceFactory;
    private SecurityFactory securityFactory;
    private String confFile;
    private boolean master;
    private ResponseCacher responseCacher;
    private OcspStoreFactoryRegister ocspStoreFactoryRegister;
    private Map<String, Responder> responders = new HashMap<String, Responder>();
    private Map<String, ResponderSigner> signers = new HashMap<String, ResponderSigner>();
    private Map<String, RequestOption> requestOptions = new HashMap<String, RequestOption>();
    private Map<String, ResponseOption> responseOptions = new HashMap<String, ResponseOption>();
    private Map<String, OcspStore> stores = new HashMap<String, OcspStore>();
    private List<String> servletPaths = new ArrayList<String>();
    private Map<String, Responder> path2responderMap = new HashMap<String, Responder>();
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public OcspServer() {
        this.datasourceFactory = new DataSourceFactory();
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    Responder getResponder(ServletURI servletUri) throws UnsupportedEncodingException {
        String path = servletUri.path();
        for (String servletPath : this.servletPaths) {
            if (!path.startsWith(servletPath)) continue;
            return this.path2responderMap.get(servletPath);
        }
        return null;
    }

    Object[] getServletPathAndResponder(ServletURI servletUri) throws UnsupportedEncodingException {
        String path = servletUri.path();
        for (String servletPath : this.servletPaths) {
            if (!path.startsWith(servletPath)) continue;
            return new Object[]{servletPath, this.path2responderMap.get(servletPath)};
        }
        return null;
    }

    public Responder getResponder(String name) {
        ParamUtil.requireNonBlank((String)"name", (String)name);
        return this.responders.get(name);
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void init() throws InvalidConfException, PasswordResolverException, DataAccessException {
        LOG.info("starting OCSPResponder server ...");
        if (this.initialized.get()) {
            LOG.info("already started, skipping ...");
            return;
        }
        try {
            this.init0();
            this.initialized.set(true);
        }
        finally {
            if (this.initialized.get()) {
                LOG.info("started OCSPResponder server");
            } else {
                LOG.error("could not start OCSPResponder server");
            }
        }
    }

    private void init0() throws InvalidConfException, DataAccessException, PasswordResolverException {
        ResponderOption option;
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        OCSPServer conf = OcspServer.parseConf(this.confFile);
        HashSet<String> set = new HashSet<String>();
        for (ResponderType responderType : conf.getResponders().getResponder()) {
            String string = responderType.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of responder named '" + string + "'");
            }
            if (StringUtil.isBlank((String)string)) {
                throw new InvalidConfException("responder name must not be empty");
            }
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
                throw new InvalidConfException("invalid OCSP responder name '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (SignerType signerType : conf.getSigners().getSigner()) {
            String string = signerType.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of signer option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (RequestOptionType requestOptionType : conf.getRequestOptions().getRequestOption()) {
            String string = requestOptionType.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of request option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (ResponseOptionType responseOptionType : conf.getResponseOptions().getResponseOption()) {
            String string = responseOptionType.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of response option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (StoreType storeType : conf.getStores().getStore()) {
            String string = storeType.getName();
            if (!set.contains(string)) continue;
            throw new InvalidConfException("duplicated definition of store named '" + string + "'");
        }
        set.clear();
        if (conf.getDatasources() != null) {
            for (DatasourceType datasourceType : conf.getDatasources().getDatasource()) {
                String string = datasourceType.getName();
                if (set.contains(string)) {
                    throw new InvalidConfException("duplicated definition of datasource named '" + string + "'");
                }
                set.add(string);
            }
        }
        this.master = conf.isMaster();
        ResponseCacheType cacheType = conf.getResponseCache();
        if (cacheType != null) {
            DataSourceWrapper dataSourceWrapper;
            DatasourceType datasourceType = cacheType.getDatasource();
            InputStream dsStream = null;
            try {
                dsStream = OcspServer.getInputStream(datasourceType.getConf());
                dataSourceWrapper = this.datasourceFactory.createDataSource(datasourceType.getName(), dsStream, this.securityFactory.getPasswordResolver());
            }
            catch (IOException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                OcspServer.close(dsStream);
            }
            this.responseCacher = new ResponseCacher(dataSourceWrapper, this.master, cacheType.getValidity());
            this.responseCacher.init();
        }
        for (SignerType signerType : conf.getSigners().getSigner()) {
            ResponderSigner signer = this.initSigner(signerType);
            this.signers.put(signerType.getName(), signer);
        }
        for (RequestOptionType requestOptionType : conf.getRequestOptions().getRequestOption()) {
            RequestOption option2 = new RequestOption(requestOptionType);
            this.requestOptions.put(requestOptionType.getName(), option2);
        }
        for (ResponseOptionType responseOptionType : conf.getResponseOptions().getResponseOption()) {
            ResponseOption option3 = new ResponseOption(responseOptionType);
            this.responseOptions.put(responseOptionType.getName(), option3);
        }
        HashMap<String, DataSourceWrapper> hashMap = new HashMap<String, DataSourceWrapper>();
        if (conf.getDatasources() != null) {
            for (DatasourceType m : conf.getDatasources().getDatasource()) {
                DataSourceWrapper datasource;
                String name2 = m.getName();
                InputStream dsStream = null;
                try {
                    dsStream = OcspServer.getInputStream(m.getConf());
                    datasource = this.datasourceFactory.createDataSource(name2, dsStream, this.securityFactory.getPasswordResolver());
                }
                catch (IOException ex) {
                    throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    OcspServer.close(dsStream);
                }
                hashMap.put(name2, datasource);
            }
        }
        HashMap<String, ResponderOption> hashMap2 = new HashMap<String, ResponderOption>();
        for (ResponderType m : conf.getResponders().getResponder()) {
            option = new ResponderOption(m);
            String optName = option.signerName();
            if (!this.signers.containsKey(optName)) {
                throw new InvalidConfException("no signer named '" + optName + "' is defined");
            }
            String reqOptName = option.requestOptionName();
            if (!this.requestOptions.containsKey(reqOptName)) {
                throw new InvalidConfException("no requestOption named '" + (String)reqOptName + "' is defined");
            }
            String respOptName = option.responseOptionName();
            if (!this.responseOptions.containsKey(respOptName)) {
                throw new InvalidConfException("no responseOption named '" + respOptName + "' is defined");
            }
            ResponseOption respOpt = this.responseOptions.get(respOptName);
            HashSet<HashAlgoType> certHashAlgos = new HashSet<HashAlgoType>(5);
            if (respOpt.isIncludeCerthash()) {
                if (respOpt.certHashAlgo() != null) {
                    certHashAlgos.add(respOpt.certHashAlgo());
                } else {
                    RequestOption reqOpt = this.requestOptions.get(reqOptName);
                    Set<HashAlgoType> algs = reqOpt.hashAlgos();
                    if (!CollectionUtil.isEmpty(algs)) {
                        certHashAlgos.addAll(algs);
                    } else {
                        HashAlgoType[] hashAlgos;
                        for (HashAlgoType hashAlgo : hashAlgos = new HashAlgoType[]{HashAlgoType.SHA1, HashAlgoType.SHA224, HashAlgoType.SHA256, HashAlgoType.SHA384, HashAlgoType.SHA512}) {
                            certHashAlgos.add(hashAlgo);
                        }
                    }
                }
            }
            List<StoreType> storeDefs = conf.getStores().getStore();
            HashSet<String> storeNames = new HashSet<String>(storeDefs.size());
            for (StoreType storeDef : storeDefs) {
                storeNames.add(storeDef.getName());
            }
            hashMap2.put(m.getName(), option);
        }
        for (StoreType m : conf.getStores().getStore()) {
            OcspStore store = this.newStore(m, hashMap);
            this.stores.put(m.getName(), store);
        }
        for (String name3 : hashMap2.keySet()) {
            option = (ResponderOption)hashMap2.get(name3);
            ArrayList<OcspStore> statusStores = new ArrayList<OcspStore>(option.storeNames().size());
            for (String storeName : option.storeNames()) {
                statusStores.add(this.stores.get(storeName));
            }
            ResponseOption responseOption = this.responseOptions.get(option.responseOptionName());
            ResponderSigner signer = this.signers.get(option.signerName());
            if (signer.isMacSigner()) {
                if (responseOption.isResponderIdByName()) {
                    throw new InvalidConfException("could not use ResponderIdByName for signer " + option.signerName());
                }
                if (EmbedCertsMode.NONE != responseOption.embedCertsMode()) {
                    throw new InvalidConfException("could not embed certifcate in response for signer " + option.signerName());
                }
            }
            Responder responder = new Responder(option, this.requestOptions.get(option.requestOptionName()), responseOption, signer, statusStores);
            this.responders.put(name3, responder);
        }
        LinkedList<SizeComparableString> tmpList = new LinkedList<SizeComparableString>();
        for (String name4 : hashMap2.keySet()) {
            Responder responder = this.responders.get(name4);
            ResponderOption option4 = (ResponderOption)hashMap2.get(name4);
            List<String> strs = option4.servletPaths();
            for (String path : strs) {
                tmpList.add(new SizeComparableString(path));
                this.path2responderMap.put(path, responder);
            }
        }
        Collections.sort(tmpList);
        ArrayList<String> list2 = new ArrayList<String>(tmpList.size());
        for (SizeComparableString m : tmpList) {
            list2.add(m.str);
        }
        this.servletPaths = list2;
    }

    public void shutdown() {
        LOG.info("stopped OCSP Responder");
        if (this.responseCacher != null) {
            this.responseCacher.shutdown();
        }
        for (OcspStore store : this.stores.values()) {
            try {
                store.shutdown();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("shutdown store " + store.name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcspRespWithCacheInfo answer(Responder responder, byte[] request, boolean viaGet) {
        int version;
        RequestOption reqOpt = responder.requestOption();
        try {
            version = OcspRequest.readRequestVersion(request);
        }
        catch (EncodingException ex) {
            String message = "could not extract version from request";
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        if (!reqOpt.isVersionAllowed(version)) {
            String message = "invalid request version " + version;
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        ResponderSigner signer = responder.signer();
        ResponseOption repOpt = responder.responseOption();
        try {
            byte[] encodeOCSPResponse;
            EmbedCertsMode certsMode;
            boolean canCacheDb;
            ExtendedExtension extn;
            Object reqOrRrrorResp = this.checkSignature(request, reqOpt);
            if (reqOrRrrorResp instanceof OcspRespWithCacheInfo) {
                return (OcspRespWithCacheInfo)reqOrRrrorResp;
            }
            OcspRequest req = (OcspRequest)reqOrRrrorResp;
            List<CertID> requestList = req.requestList();
            int requestsSize = requestList.size();
            if (requestsSize > reqOpt.maxRequestListCount()) {
                String message = requestsSize + " entries in RequestList, but maximal " + reqOpt.maxRequestListCount() + " is allowed";
                LOG.warn(message);
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            OcspRespControl repControl = new OcspRespControl();
            repControl.canCacheInfo = true;
            ResponderID responderId = signer.getResponderId(repOpt.isResponderIdByName());
            List<ExtendedExtension> reqExtensions = req.extensions();
            LinkedList<Extension> respExtensions = new LinkedList<Extension>();
            ExtendedExtension nonceExtn = OcspServer.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_NONCE);
            if (nonceExtn != null) {
                if (reqOpt.nonceOccurrence() == TripleState.FORBIDDEN) {
                    LOG.warn("nonce forbidden, but is present in the request");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                int len = nonceExtn.extnValueLength();
                int min = reqOpt.nonceMinLen();
                int max = reqOpt.nonceMaxLen();
                if (len < min || len > max) {
                    LOG.warn("length of nonce {} not within [{},{}]", new Object[]{len, min, max});
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                repControl.canCacheInfo = false;
                respExtensions.add(nonceExtn);
            } else if (reqOpt.nonceOccurrence() == TripleState.REQUIRED) {
                LOG.warn("nonce required, but is not present in the request");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            ConcurrentContentSigner concurrentSigner = null;
            if (responder.responderOption().mode() != OcspMode.RFC2560 && (extn = OcspServer.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_PREFSIGALGS)) != null) {
                ArrayList<AlgorithmIdentifier> prefSigAlgs;
                try (ASN1InputStream asn1Stream = new ASN1InputStream(extn.getExtnValueStream());){
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1Stream.readObject());
                    int size = seq.size();
                    prefSigAlgs = new ArrayList<AlgorithmIdentifier>(size);
                    for (int i = 0; i < size; ++i) {
                        prefSigAlgs.add(AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(i)));
                    }
                }
                concurrentSigner = signer.getSignerForPreferredSigAlgs(prefSigAlgs);
            }
            if (!reqExtensions.isEmpty()) {
                boolean flag = false;
                for (Object m : reqExtensions) {
                    if (!m.isCritical()) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    if (LOG.isWarnEnabled()) {
                        LinkedList<OID> oids = new LinkedList<OID>();
                        for (ExtendedExtension m : reqExtensions) {
                            if (!m.isCritical()) continue;
                            oids.add(m.extnType());
                        }
                        LOG.warn("could not process critial request extensions: {}", oids);
                    }
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
            }
            if (concurrentSigner == null) {
                concurrentSigner = signer.firstSigner();
            }
            AlgorithmCode cacheDbSigAlgCode = null;
            AlgorithmCode cacheDbCertHashAlgCode = null;
            BigInteger cacheDbSerialNumber = null;
            Integer cacheDbIssuerId = null;
            boolean bl = canCacheDb = requestsSize == 1 && this.responseCacher != null && nonceExtn == null && this.responseCacher.isOnService();
            if (canCacheDb) {
                CertID certId = requestList.get(0);
                HashAlgoType reqHashAlgo = certId.issuer().hashAlgorithm();
                if (!reqOpt.allows(reqHashAlgo)) {
                    if (reqHashAlgo != null) {
                        LOG.warn("CertID.hashAlgorithm {} not allowed", (Object)reqHashAlgo);
                    } else {
                        LOG.warn("CertID.hashAlgorithm {} not allowed", (Object)certId.issuer().hashAlgorithmOID());
                    }
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                HashAlgoType certHashAlgo = repOpt.certHashAlgo();
                if (certHashAlgo == null) {
                    certHashAlgo = reqHashAlgo;
                }
                cacheDbCertHashAlgCode = certHashAlgo.algorithmCode();
                cacheDbSigAlgCode = concurrentSigner.algorithmCode();
                cacheDbIssuerId = this.responseCacher.getIssuerId(certId.issuer());
                cacheDbSerialNumber = certId.serialNumber();
                if (cacheDbIssuerId != null) {
                    OcspRespWithCacheInfo cachedResp = this.responseCacher.getOcspResponse(cacheDbIssuerId, cacheDbSerialNumber, cacheDbSigAlgCode, cacheDbCertHashAlgCode);
                    if (cachedResp != null) {
                        return cachedResp;
                    }
                } else if (this.master) {
                    OcspStore store;
                    X509Certificate issuerCert = null;
                    Iterator<OcspStore> iterator = responder.stores().iterator();
                    while (iterator.hasNext() && (issuerCert = (store = iterator.next()).getIssuerCert(certId.issuer())) == null) {
                    }
                    if (issuerCert != null) {
                        cacheDbIssuerId = this.responseCacher.storeIssuer(issuerCert);
                    }
                }
                if (cacheDbIssuerId == null) {
                    canCacheDb = false;
                }
            }
            OCSPRespBuilder builder = new OCSPRespBuilder(responderId);
            for (int i = 0; i < requestsSize; ++i) {
                OcspRespWithCacheInfo failureOcspResp = this.processCertReq(requestList.get(i), builder, responder, reqOpt, repOpt, repControl);
                if (failureOcspResp == null) continue;
                return failureOcspResp;
            }
            if (repControl.includeExtendedRevokeExtension) {
                respExtensions.add(extension_pkix_ocsp_extendedRevoke);
            }
            if (!respExtensions.isEmpty()) {
                Extensions extns = new Extensions(respExtensions);
                builder.setResponseExtensions(extns);
            }
            Object certsInResp = (certsMode = repOpt.embedCertsMode()) == EmbedCertsMode.SIGNER ? signer.sequenceOfCertificate() : (certsMode == EmbedCertsMode.NONE ? null : signer.sequenceOfCertificateChain());
            try {
                encodeOCSPResponse = builder.buildOCSPResponse(concurrentSigner, (TaggedCertSequence)((Object)certsInResp), new Date());
            }
            catch (NoIdleSignerException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
            }
            catch (OCSPException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"answer() basicOcspBuilder.build");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
            }
            if (canCacheDb && repControl.canCacheInfo) {
                this.responseCacher.storeOcspResponse(cacheDbIssuerId, cacheDbSerialNumber, repControl.cacheThisUpdate, repControl.cacheNextUpdate, cacheDbSigAlgCode, cacheDbCertHashAlgCode, encodeOCSPResponse);
            }
            if (viaGet && repControl.canCacheInfo) {
                OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = new OcspRespWithCacheInfo.ResponseCacheInfo(repControl.cacheThisUpdate);
                if (repControl.cacheNextUpdate != Long.MAX_VALUE) {
                    cacheInfo.setNextUpdate(repControl.cacheNextUpdate);
                }
                return new OcspRespWithCacheInfo(encodeOCSPResponse, cacheInfo);
            }
            return new OcspRespWithCacheInfo(encodeOCSPResponse, null);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
        }
    }

    private OcspRespWithCacheInfo processCertReq(CertID certId, OCSPRespBuilder builder, Responder responder, RequestOption reqOpt, ResponseOption repOpt, OcspRespControl repControl) throws IOException {
        byte[] certStatus;
        Date thisUpdate;
        HashAlgoType reqHashAlgo = certId.issuer().hashAlgorithm();
        if (!reqOpt.allows(reqHashAlgo)) {
            LOG.warn("CertID.hashAlgorithm {} not allowed", (Object)reqHashAlgo);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        CertStatusInfo certStatusInfo = null;
        boolean exceptionOccurs = false;
        BigInteger serial = certId.serialNumber();
        Date now = new Date();
        for (OcspStore store : responder.stores()) {
            try {
                certStatusInfo = store.getCertStatus(now, certId.issuer(), serial, repOpt.isIncludeCerthash(), repOpt.isIncludeInvalidityDate(), responder.responderOption().inheritCaRevocation(), repOpt.certHashAlgo());
                if (certStatusInfo == null) continue;
                break;
            }
            catch (OcspStoreException ex) {
                exceptionOccurs = true;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("getCertStatus() of CertStatusStore " + store.name()));
            }
        }
        if (certStatusInfo == null) {
            if (exceptionOccurs) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
            }
            certStatusInfo = CertStatusInfo.getIssuerUnknownCertStatusInfo((Date)new Date(), null);
        }
        if ((thisUpdate = certStatusInfo.thisUpdate()) == null) {
            thisUpdate = new Date();
        }
        Date nextUpdate = certStatusInfo.nextUpdate();
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        boolean unknownAsRevoked = false;
        switch (certStatusInfo.certStatus()) {
            case GOOD: {
                certStatus = bytes_certstatus_good;
                break;
            }
            case ISSUER_UNKNOWN: {
                repControl.canCacheInfo = false;
                certStatus = bytes_certstatus_unknown;
                break;
            }
            case UNKNOWN: 
            case IGNORE: {
                repControl.canCacheInfo = false;
                if (responder.responderOption().mode() == OcspMode.RFC2560) {
                    certStatus = bytes_certstatus_unknown;
                    break;
                }
                unknownAsRevoked = true;
                repControl.includeExtendedRevokeExtension = true;
                certStatus = bytes_certstatus_rfc6960_unknown;
                break;
            }
            case REVOKED: {
                CertRevocationInfo revInfo = certStatusInfo.revocationInfo();
                certStatus = Template.getEncodeRevokedInfo(repOpt.isIncludeRevReason() ? revInfo.reason() : null, revInfo.revocationTime());
                Date invalidityDate = revInfo.invalidityTime();
                if (!repOpt.isIncludeInvalidityDate() || invalidityDate == null || invalidityDate.equals(revInfo.revocationTime())) break;
                extensions.add(Template.getInvalidityDateExtension(invalidityDate));
                break;
            }
            default: {
                throw new RuntimeException("unknown CertificateStatus:" + certStatusInfo.certStatus());
            }
        }
        byte[] certHash = certStatusInfo.certHash();
        if (certHash != null) {
            extensions.add(Template.getCertHashExtension(certStatusInfo.certHashAlgo(), certHash));
        }
        if (certStatusInfo.archiveCutOff() != null) {
            extensions.add(Template.getArchiveOffExtension(certStatusInfo.archiveCutOff()));
        }
        if (LOG.isDebugEnabled()) {
            String certStatusText = null;
            certStatusText = Arrays.equals(certStatus, bytes_certstatus_good) ? "good" : (Arrays.equals(certStatus, bytes_certstatus_unknown) ? "unknown" : (Arrays.equals(certStatus, bytes_certstatus_rfc6960_unknown) ? "RFC6969_unknown" : (unknownAsRevoked ? "unknown_as_revoked" : "revoked")));
            StringBuilder sb = new StringBuilder(250);
            sb.append("issuer: ").append(certId.issuer()).append(", ");
            sb.append("serialNumber: ").append(LogUtil.formatCsn((BigInteger)certId.serialNumber())).append(", ");
            sb.append("certStatus: ").append(certStatusText).append(", ");
            sb.append("thisUpdate: ").append(thisUpdate).append(", ");
            sb.append("nextUpdate: ").append(nextUpdate);
            if (certHash != null) {
                sb.append(", certHash: ").append(Hex.toHexString((byte[])certHash).toUpperCase());
            }
            LOG.debug(sb.toString());
        }
        if (CollectionUtil.isEmpty(extensions)) {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, null);
        } else {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, new Extensions(extensions));
        }
        repControl.cacheThisUpdate = Math.max(repControl.cacheThisUpdate, thisUpdate.getTime());
        if (nextUpdate != null) {
            repControl.cacheNextUpdate = Math.min(repControl.cacheNextUpdate, nextUpdate.getTime());
        }
        return null;
    }

    public HealthCheckResult healthCheck(Responder responder) {
        HealthCheckResult result = new HealthCheckResult("OCSPResponder");
        boolean healthy = true;
        for (OcspStore store : responder.stores()) {
            boolean storeHealthy = store.isHealthy();
            healthy &= storeHealthy;
            HealthCheckResult storeHealth = new HealthCheckResult("CertStatusStore." + store.name());
            storeHealth.setHealthy(storeHealthy);
            result.addChildCheck(storeHealth);
        }
        boolean signerHealthy = responder.signer().isHealthy();
        HealthCheckResult signerHealth = new HealthCheckResult("Signer");
        signerHealth.setHealthy(signerHealthy);
        result.addChildCheck(signerHealth);
        result.setHealthy(healthy &= signerHealthy);
        return result;
    }

    public void setOcspStoreFactoryRegister(OcspStoreFactoryRegister ocspStoreFactoryRegister) {
        this.ocspStoreFactoryRegister = ocspStoreFactoryRegister;
    }

    private ResponderSigner initSigner(SignerType signerType) throws InvalidConfException {
        X509Certificate[] explicitCertificateChain = null;
        X509Certificate explicitResponderCert = null;
        if (signerType.getCert() != null) {
            explicitResponderCert = OcspServer.parseCert(signerType.getCert());
        }
        if (explicitResponderCert != null) {
            HashSet<X509Certificate> caCerts = null;
            if (signerType.getCaCerts() != null) {
                caCerts = new HashSet<X509Certificate>();
                for (FileOrValueType certConf : signerType.getCaCerts().getCaCert()) {
                    caCerts.add(OcspServer.parseCert(certConf));
                }
            }
            explicitCertificateChain = X509Util.buildCertPath((X509Certificate)explicitResponderCert, caCerts);
        }
        String responderSignerType = signerType.getType();
        String responderKeyConf = signerType.getKey();
        List<String> sigAlgos = signerType.getAlgorithms().getAlgorithm();
        ArrayList<ConcurrentContentSigner> singleSigners = new ArrayList<ConcurrentContentSigner>(sigAlgos.size());
        for (String sigAlgo : sigAlgos) {
            try {
                ConcurrentContentSigner requestorSigner = this.securityFactory.createSigner(responderSignerType, new SignerConf("algo=" + sigAlgo + "," + responderKeyConf), explicitCertificateChain);
                singleSigners.add(requestorSigner);
            }
            catch (ObjectCreationException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            return new ResponderSigner(singleSigners);
        }
        catch (IOException | CertificateException ex) {
            throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
        }
    }

    private OcspStore newStore(StoreType conf, Map<String, DataSourceWrapper> datasources) throws InvalidConfException {
        DbCertStatusStore store;
        String type = conf.getSource().getType();
        if ("CRL".equalsIgnoreCase(type)) {
            store = new CrlDbCertStatusStore();
        } else if ("XIPKI-DB".equals(type)) {
            store = new DbCertStatusStore();
        } else {
            try {
                store = this.ocspStoreFactoryRegister.newOcspStore(conf.getSource().getType());
            }
            catch (ObjectCreationException ex) {
                throw new InvalidConfException("ObjectCreationException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
            }
        }
        store.setName(conf.getName());
        Integer interval = conf.getRetentionInterval();
        int retentionInterva = interval == null ? -1 : interval;
        store.setRetentionInterval(retentionInterva);
        store.setUnknownSerialAsGood(OcspServer.getBoolean(conf.isUnknownSerialAsGood(), false));
        store.setIncludeArchiveCutoff(OcspServer.getBoolean(conf.isIncludeArchiveCutoff(), true));
        store.setIncludeCrlId(OcspServer.getBoolean(conf.isIncludeCrlID(), true));
        store.setIgnoreExpiredCert(OcspServer.getBoolean(conf.isIgnoreExpiredCert(), true));
        store.setIgnoreNotYetValidCert(OcspServer.getBoolean(conf.isIgnoreNotYetValidCert(), true));
        String datasourceName = conf.getSource().getDatasource();
        DataSourceWrapper datasource = null;
        if (datasourceName != null && (datasource = datasources.get(datasourceName)) == null) {
            throw new InvalidConfException("datasource named '" + datasourceName + "' not defined");
        }
        try {
            store.init(conf.getSource().getConf(), datasource);
        }
        catch (OcspStoreException ex) {
            throw new InvalidConfException("CertStatusStoreException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
        }
        return store;
    }

    private Object checkSignature(byte[] request, RequestOption requestOption) throws OCSPException, CertificateParsingException, InvalidAlgorithmParameterException {
        ContentVerifierProvider cvp;
        OCSPRequest req;
        try {
            if (!requestOption.isValidateSignature()) {
                return OcspRequest.getInstance(request);
            }
            if (!OcspRequest.containsSignature(request)) {
                if (requestOption.isSignatureRequired()) {
                    LOG.warn("signature in request required");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.sigRequired);
                }
                return OcspRequest.getInstance(request);
            }
            try {
                req = OCSPRequest.getInstance((Object)request);
            }
            catch (IllegalArgumentException ex) {
                throw new EncodingException("could not parse OCSP request", ex);
            }
        }
        catch (EncodingException ex) {
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        OCSPReq ocspReq = new OCSPReq(req);
        X509CertificateHolder[] certs = ocspReq.getCerts();
        if (certs == null || certs.length < 1) {
            LOG.warn("no certificate found in request to verify the signature");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        try {
            cvp = this.securityFactory.getContentVerifierProvider(certs[0]);
        }
        catch (InvalidKeyException ex) {
            String message = ex.getMessage();
            LOG.warn("securityFactory.getContentVerifierProvider, InvalidKeyException: {}", (Object)message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        boolean sigValid = ocspReq.isSignatureValid(cvp);
        if (!sigValid) {
            LOG.warn("request signature is invalid");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        Date referenceTime = new Date();
        if (OcspServer.canBuildCertpath(certs, requestOption, referenceTime)) {
            try {
                return OcspRequest.getInstance(req);
            }
            catch (EncodingException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
        }
        LOG.warn("could not build certpath for the request's signer certificate");
        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
    }

    private static boolean canBuildCertpath(X509CertificateHolder[] certsInReq, RequestOption requestOption, Date referenceTime) {
        Set<X509Certificate> configuredCerts;
        X509Certificate target;
        try {
            target = X509Util.toX509Cert((Certificate)certsInReq[0].toASN1Structure());
        }
        catch (CertificateException ex) {
            return false;
        }
        HashSet<X509Certificate> certstore = new HashSet<X509Certificate>();
        Set<CertWithEncoded> trustAnchors = requestOption.trustAnchors();
        for (CertWithEncoded m : trustAnchors) {
            certstore.add(m.certificate());
        }
        int n = certsInReq.length;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                X509Certificate cert;
                try {
                    cert = X509Util.toX509Cert((Certificate)certsInReq[i].toASN1Structure());
                }
                catch (CertificateException ex) {
                    continue;
                }
                certstore.add(cert);
            }
        }
        if (CollectionUtil.isNonEmpty(configuredCerts = requestOption.certs())) {
            certstore.addAll(requestOption.certs());
        }
        X509Certificate[] certpath = X509Util.buildCertPath((X509Certificate)target, certstore);
        CertpathValidationModel model = requestOption.certpathValidationModel();
        Date now = new Date();
        if (model == null || model == CertpathValidationModel.PKIX) {
            for (X509Certificate x509Certificate : certpath) {
                if (!x509Certificate.getNotBefore().after(now) && !x509Certificate.getNotAfter().before(now)) continue;
                return false;
            }
        } else if (model != CertpathValidationModel.CHAIN) {
            throw new RuntimeException("invalid CertpathValidationModel " + model.name());
        }
        for (int i = certpath.length - 1; i >= 0; --i) {
            X509Certificate targetCert = certpath[i];
            for (CertWithEncoded certWithEncoded : trustAnchors) {
                if (!certWithEncoded.equalsCert(targetCert)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getBoolean(Boolean bo, boolean defaultValue) {
        return bo == null ? defaultValue : bo;
    }

    private static InputStream getInputStream(FileOrValueType conf) throws IOException {
        return conf.getFile() != null ? new FileInputStream(IoUtil.expandFilepath((String)conf.getFile())) : new ByteArrayInputStream(conf.getValue());
    }

    private static InputStream getInputStream(FileOrPlainValueType conf) throws IOException {
        return conf.getFile() != null ? new FileInputStream(IoUtil.expandFilepath((String)conf.getFile())) : new ByteArrayInputStream(conf.getValue().getBytes());
    }

    private static void close(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOG.warn("could not close stream: {}", (Object)ex.getMessage());
        }
    }

    private static X509Certificate parseCert(FileOrValueType certConf) throws InvalidConfException {
        InputStream is = null;
        try {
            is = OcspServer.getInputStream(certConf);
            X509Certificate x509Certificate = X509Util.parseCert((InputStream)is);
            return x509Certificate;
        }
        catch (IOException | CertificateException ex) {
            String msg = "could not parse certificate";
            if (certConf.getFile() != null) {
                msg = msg + " from file " + certConf.getFile();
            }
            throw new InvalidConfException(msg);
        }
        finally {
            OcspServer.close(is);
        }
    }

    private static OCSPServer parseConf(String confFilename) throws InvalidConfException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFact.newSchema(OcspServer.class.getResource("/xsd/ocsp-conf.xsd"));
            unmarshaller.setSchema(schema);
            return (OCSPServer)unmarshaller.unmarshal(new File(IoUtil.expandFilepath((String)confFilename)));
        }
        catch (SAXException ex) {
            throw new InvalidConfException("parse profile failed, message: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new InvalidConfException("parse profile failed, message: " + XmlUtil.getMessage((JAXBException)ex), (Throwable)ex);
        }
    }

    private static ExtendedExtension removeExtension(List<ExtendedExtension> extensions, OID extnType) {
        ExtendedExtension extn = null;
        for (ExtendedExtension m : extensions) {
            if (extnType != m.extnType()) continue;
            extn = m;
            break;
        }
        if (extn != null) {
            extensions.remove((Object)extn);
        }
        return extn;
    }

    static {
        LOG = LoggerFactory.getLogger(OcspServer.class);
        unsuccesfulOCSPRespMap = new HashMap<OcspResponseStatus, OcspRespWithCacheInfo>(10);
        for (OcspResponseStatus status : OcspResponseStatus.values()) {
            byte[] encoded;
            if (status == OcspResponseStatus.successful) continue;
            OCSPResponse resp = new OCSPResponse(new OCSPResponseStatus(status.status()), null);
            try {
                encoded = resp.getEncoded();
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError("could not encode OCSPResp for status " + (Object)((Object)status) + ": " + ex.getMessage());
            }
            unsuccesfulOCSPRespMap.put(status, new OcspRespWithCacheInfo(encoded, null));
        }
        ExtendedExtension ext = new ExtendedExtension(OID.ID_PKIX_OCSP_EXTENDEDREVOKE, true, DERNullBytes);
        byte[] encoded = new byte[ext.encodedLength()];
        ext.write(encoded, 0);
        extension_pkix_ocsp_extendedRevoke = new WritableOnlyExtension(encoded);
    }

    private static class OcspRespControl {
        boolean canCacheInfo;
        boolean includeExtendedRevokeExtension = false;
        long cacheThisUpdate = 0L;
        long cacheNextUpdate = Long.MAX_VALUE;
    }

    private static class SizeComparableString
    implements Comparable<SizeComparableString> {
        private String str;

        public SizeComparableString(String str) {
            this.str = (String)ParamUtil.requireNonNull((String)"str", (Object)str);
        }

        @Override
        public int compareTo(SizeComparableString obj) {
            if (this.str.length() == obj.str.length()) {
                return 0;
            }
            return this.str.length() > obj.str.length() ? 1 : -1;
        }
    }
}

