/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.xipki.common.util.ParamUtil;

public class CertWithEncoded {
    private final X509Certificate certificate;
    private final String className;
    private final byte[] encoded;

    public CertWithEncoded(X509Certificate cert) throws CertificateEncodingException {
        this.certificate = (X509Certificate)ParamUtil.requireNonNull((String)"cert", (Object)cert);
        this.className = cert.getClass().getName();
        this.encoded = cert.getEncoded();
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public boolean equalsCert(X509Certificate cert) {
        byte[] encodedCert;
        if (cert == null) {
            return false;
        }
        if (this.certificate == cert) {
            return true;
        }
        if (this.className.equals(cert.getClass().getName())) {
            return this.certificate.equals(cert);
        }
        if (this.certificate.equals(cert)) {
            return true;
        }
        try {
            encodedCert = cert.getEncoded();
        }
        catch (CertificateEncodingException ex) {
            return false;
        }
        return Arrays.equals(this.encoded, encodedCert);
    }
}

