/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api.internal;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreFactory;
import org.xipki.ocsp.api.OcspStoreFactoryRegister;

public class OcspStoreFactoryRegisterImpl
implements OcspStoreFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(OcspStoreFactoryRegisterImpl.class);
    private ConcurrentLinkedDeque<OcspStoreFactory> services = new ConcurrentLinkedDeque();

    @Override
    public OcspStore newOcspStore(String type) throws ObjectCreationException {
        ParamUtil.requireNonBlank((String)"type", (String)type);
        for (OcspStoreFactory service : this.services) {
            if (!service.canCreateOcspStore(type)) continue;
            LOG.info("found factory to create OcspStore of type '" + type + "'");
            return service.newOcspStore(type);
        }
        throw new ObjectCreationException("could not find factory to create OcspStore of type '" + type + "'");
    }

    public void bindService(OcspStoreFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} CertStatusStoreFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(OcspStoreFactory service) {
        if (service == null) {
            LOG.info("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed CertStatusStoreFactory binding for {}", (Object)service);
        } else {
            LOG.info("no CertStatusStoreFactory binding found to remove for '{}'", (Object)service);
        }
    }
}

