/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.ASN1Type;
import org.xipki.common.util.CompareUtil;
import org.xipki.security.HashAlgoType;

public class RequestIssuer {
    private final HashAlgoType hashAlgo;
    private final byte[] data;
    private final int from;
    private final int nameHashFrom;
    private final int len;

    public RequestIssuer(HashAlgoType hashAlgo, byte[] hashData) {
        int algIdLen = 2 + hashAlgo.encodedLength() + 2;
        this.data = new byte[algIdLen + hashData.length];
        int offset = 0;
        this.data[offset++] = 48;
        this.data[offset++] = (byte)(hashAlgo.encodedLength() + 2);
        offset += hashAlgo.write(this.data, offset);
        this.data[offset++] = 5;
        this.data[offset++] = 0;
        this.nameHashFrom = offset;
        offset += ASN1Type.arraycopy((byte[])hashData, (byte[])this.data, (int)offset);
        this.from = 0;
        this.len = offset;
        this.hashAlgo = hashAlgo;
    }

    public RequestIssuer(byte[] data) {
        this(data, 0, data.length);
    }

    public RequestIssuer(byte[] data, int from, int len) {
        this.data = data;
        this.from = from;
        this.len = len;
        this.hashAlgo = HashAlgoType.getInstanceForEncoded((byte[])data, (int)(from + 2), (int)(2 + data[from + 3]));
        int hashAlgoFieldLen = 0xFF & data[from + 1];
        this.nameHashFrom = from + 2 + hashAlgoFieldLen;
    }

    public HashAlgoType hashAlgorithm() {
        return this.hashAlgo;
    }

    public String hashAlgorithmOID() {
        if (this.hashAlgo != null) {
            return this.hashAlgo.oid().getId();
        }
        int start = this.from + 2;
        byte[] bytes = Arrays.copyOfRange(this.data, start, start + 2 + (0xFF & this.data[this.from + 3]));
        return ASN1ObjectIdentifier.getInstance((Object)bytes).getId();
    }

    public int from() {
        return this.from;
    }

    public byte[] data() {
        return this.data;
    }

    public int nameHashFrom() {
        return this.nameHashFrom;
    }

    public int length() {
        return this.len;
    }

    public int write(byte[] out, int offset) {
        System.arraycopy(this.data, this.from, out, offset, this.len);
        return this.len;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestIssuer)) {
            return false;
        }
        RequestIssuer other = (RequestIssuer)obj;
        if (this.len != other.len) {
            return false;
        }
        return CompareUtil.areEqual((byte[])this.data, (int)this.from, (byte[])other.data, (int)other.from, (int)this.len);
    }

    public String toString() {
        return Hex.toHexString((byte[])this.data, (int)this.from, (int)this.len);
    }
}

