/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.util.Date;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.api.CertStatus;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgoType;

public class CertStatusInfo {
    private final CertStatus certStatus;
    private CertRevocationInfo revocationInfo;
    private HashAlgoType certHashAlgo;
    private byte[] certHash;
    private final Date thisUpdate;
    private final Date nextUpdate;
    private final String certprofile;
    private CrlID crlId;
    private Date archiveCutOff;

    private CertStatusInfo(CertStatus certStatus, Date thisUpdate, Date nextUpdate, String certprofile) {
        this.certStatus = (CertStatus)((Object)ParamUtil.requireNonNull((String)"certStatus", (Object)((Object)certStatus)));
        this.thisUpdate = (Date)ParamUtil.requireNonNull((String)"thisUpdate", (Object)thisUpdate);
        this.nextUpdate = nextUpdate;
        this.certprofile = certprofile;
    }

    public Date thisUpdate() {
        return this.thisUpdate;
    }

    public Date nextUpdate() {
        return this.nextUpdate;
    }

    public CertStatus certStatus() {
        return this.certStatus;
    }

    public CertRevocationInfo revocationInfo() {
        return this.revocationInfo;
    }

    public HashAlgoType certHashAlgo() {
        return this.certHashAlgo;
    }

    public byte[] certHash() {
        return this.certHash;
    }

    public String certprofile() {
        return this.certprofile;
    }

    public CrlID crlId() {
        return this.crlId;
    }

    public void setCrlId(CrlID crlId) {
        this.crlId = crlId;
    }

    public Date archiveCutOff() {
        return this.archiveCutOff;
    }

    public void setArchiveCutOff(Date archiveCutOff) {
        this.archiveCutOff = archiveCutOff;
    }

    public static CertStatusInfo getUnknownCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIgnoreCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.IGNORE, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIssuerUnknownCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.ISSUER_UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getGoodCertStatusInfo(HashAlgoType certHashAlgo, byte[] certHash, Date thisUpdate, Date nextUpdate, String certprofile) {
        CertStatusInfo ret = new CertStatusInfo(CertStatus.GOOD, thisUpdate, nextUpdate, certprofile);
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }

    public static CertStatusInfo getRevokedCertStatusInfo(CertRevocationInfo revocationInfo, HashAlgoType certHashAlgo, byte[] certHash, Date thisUpdate, Date nextUpdate, String certprofile) {
        if (revocationInfo == null) {
            throw new IllegalArgumentException("revocationInfo must not be null");
        }
        CertStatusInfo ret = new CertStatusInfo(CertStatus.REVOKED, thisUpdate, nextUpdate, certprofile);
        ret.revocationInfo = revocationInfo;
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }
}

