/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password.callback;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordProducer;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.callback.PasswordCallback;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class PBEConsumerPasswordCallback
implements PasswordCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PBEConsumerPasswordCallback.class);
    private String passwordName;
    private int tries = 3;

    private boolean isPasswordValid(char[] password, String testToken) {
        if (StringUtil.isBlank((String)testToken)) {
            return true;
        }
        try {
            PBEPasswordService.decryptPassword(password, testToken);
            return true;
        }
        catch (PasswordResolverException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getPassword(String prompt, String testToken) throws PasswordResolverException {
        if (this.passwordName == null) {
            throw new PasswordResolverException("please initialize me first");
        }
        try {
            for (int i = 0; i < this.tries; ++i) {
                char[] password;
                try {
                    password = PasswordProducer.takePassword(this.passwordName);
                }
                catch (InterruptedException ex) {
                    throw new PasswordResolverException("interrupted");
                }
                boolean valid = this.isPasswordValid(password, testToken);
                PasswordProducer.setPasswordCorrect(this.passwordName, valid);
                if (!valid) continue;
                char[] cArray = password;
                return cArray;
            }
        }
        finally {
            PasswordProducer.unregisterPasswordConsumer(this.passwordName);
        }
        String msg = "Could not get the password " + this.passwordName + "after " + this.tries + " tries";
        LOG.error(msg);
        System.out.println(msg);
        throw new PasswordResolverException(msg);
    }

    @Override
    public void init(String conf) throws PasswordResolverException {
        int intValue;
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("name");
        if (StringUtil.isBlank((String)str)) {
            throw new PasswordResolverException("name must not be null");
        }
        this.passwordName = str;
        PasswordProducer.registerPasswordConsumer(this.passwordName);
        str = pairs.value("tries");
        if (StringUtil.isNotBlank((String)str) && (intValue = Integer.parseInt(str)) > 0) {
            this.tries = intValue;
        }
    }
}

