/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Version;
import iaik.pkcs.pkcs11.params.Params;
import sun.security.pkcs11.wrapper.CK_VERSION;

public class VersionParams
implements Params {
    private Version version;

    public VersionParams(Version version) {
        this.version = Util.requireNonNull("version", version);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        return new CK_VERSION(this.version.getMajor(), this.version.getMinor());
    }

    public void setPKCS11ParamsObject(CK_VERSION input) {
        this.version = new Version(input);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof VersionParams)) {
            return false;
        }
        VersionParams other = (VersionParams)otherObject;
        return this.version.equals(other.version);
    }

    public String toString() {
        return Util.concatObjects("Version: ", this.version);
    }
}

