/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;
import iaik.pkcs.pkcs11.params.SSL3RandomDataParams;
import iaik.pkcs.pkcs11.params.VersionParams;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_VERSION;

public class SSL3MasterKeyDeriveParams
implements Params {
    protected SSL3RandomDataParams randomInfo;
    protected VersionParams version;

    public SSL3MasterKeyDeriveParams(SSL3RandomDataParams randomInfo, VersionParams version) {
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
        this.version = Util.requireNonNull("version", version);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_SSL3_MASTER_KEY_DERIVE_PARAMS params = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS((CK_SSL3_RANDOM_DATA)this.randomInfo.getPKCS11ParamsObject(), (CK_VERSION)this.version.getPKCS11ParamsObject());
        return params;
    }

    public SSL3RandomDataParams getRandomInfo() {
        return this.randomInfo;
    }

    public VersionParams getVersion() {
        return this.version;
    }

    public void setRandomInfo(SSL3RandomDataParams randomInfo) {
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
    }

    public void setVersion(VersionParams version) {
        this.version = Util.requireNonNull("version", version);
    }

    public String toString() {
        return Util.concatObjects("  Random Information:\n", this.randomInfo, "\n  Version: ", this.version);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SSL3MasterKeyDeriveParams)) {
            return false;
        }
        SSL3MasterKeyDeriveParams other = (SSL3MasterKeyDeriveParams)otherObject;
        return this.randomInfo.equals(other.randomInfo) && this.version.equals(other.version);
    }

    public int hashCode() {
        return this.randomInfo.hashCode() ^ this.version.hashCode();
    }
}

