/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;
import iaik.pkcs.pkcs11.params.SSL3KeyMaterialOutParams;
import iaik.pkcs.pkcs11.params.SSL3RandomDataParams;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;

public class SSL3KeyMaterialParams
implements Params {
    protected long macSizeInBits;
    protected long keySizeInBits;
    protected long ivSizeInBits;
    protected boolean export;
    protected SSL3RandomDataParams randomInfo;
    protected SSL3KeyMaterialOutParams returnedKeyMaterial;

    public SSL3KeyMaterialParams(long macSizeInBits, long keySizeInBits, long ivSizeInBits, boolean export, SSL3RandomDataParams randomInfo, SSL3KeyMaterialOutParams returnedKeyMaterial) {
        this.macSizeInBits = macSizeInBits;
        this.keySizeInBits = keySizeInBits;
        this.ivSizeInBits = ivSizeInBits;
        this.export = export;
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
        this.returnedKeyMaterial = Util.requireNonNull("returnedKeyMaterial", returnedKeyMaterial);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_SSL3_KEY_MAT_PARAMS params = new CK_SSL3_KEY_MAT_PARAMS((int)this.macSizeInBits, (int)this.keySizeInBits, (int)this.ivSizeInBits, this.export, (CK_SSL3_RANDOM_DATA)this.randomInfo.getPKCS11ParamsObject());
        params.pReturnedKeyMaterial = (CK_SSL3_KEY_MAT_OUT)this.returnedKeyMaterial.getPKCS11ParamsObject();
        return params;
    }

    public long getMacSizeInBits() {
        return this.macSizeInBits;
    }

    public long getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public long getIVSizeInBits() {
        return this.ivSizeInBits;
    }

    public boolean isExport() {
        return this.export;
    }

    public SSL3RandomDataParams getRandomInfo() {
        return this.randomInfo;
    }

    public SSL3KeyMaterialOutParams getReturnedKeyMaterial() {
        return this.returnedKeyMaterial;
    }

    public void setMacSizeInBits(long macSizeInBits) {
        this.macSizeInBits = macSizeInBits;
    }

    public void setKeySizeInBits(long keySizeInBits) {
        this.keySizeInBits = keySizeInBits;
    }

    public void setIVSizeInBits(long ivSizeInBits) {
        this.ivSizeInBits = ivSizeInBits;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public void setRandomInfo(SSL3RandomDataParams randomInfo) {
        this.randomInfo = Util.requireNonNull("randomInfo", randomInfo);
    }

    public void setReturnedKeyMaterial(SSL3KeyMaterialOutParams returnedKeyMaterial) {
        this.returnedKeyMaterial = Util.requireNonNull("returnedKeyMaterial", returnedKeyMaterial);
    }

    public String toString() {
        return Util.concatObjects("  MAC Size in Bits (dec): ", this.macSizeInBits, "\n  Key Size in Bits (dec): ", this.keySizeInBits, "\n  IV Size in Bits (dec): ", this.ivSizeInBits, "\n  For Export Version: ", this.export, "\n  Client's and Server'S Random Information (hex):\n", this.randomInfo, "\n  Handles of the generated Keys and IVs: ", this.returnedKeyMaterial);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SSL3KeyMaterialParams)) {
            return false;
        }
        SSL3KeyMaterialParams other = (SSL3KeyMaterialParams)otherObject;
        return this.macSizeInBits == other.macSizeInBits && this.keySizeInBits == other.keySizeInBits && this.ivSizeInBits == other.ivSizeInBits && this.export == other.export && this.randomInfo.equals(other.randomInfo) && this.returnedKeyMaterial.equals(other.returnedKeyMaterial);
    }

    public int hashCode() {
        return (int)this.macSizeInBits ^ (int)this.keySizeInBits ^ (int)this.ivSizeInBits ^ this.randomInfo.hashCode() ^ this.returnedKeyMaterial.hashCode();
    }
}

