/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;
import java.util.Arrays;
import sun.security.pkcs11.wrapper.CK_PKCS5_PBKD2_PARAMS;

public class PKCS5PBKD2Params
implements Params {
    protected long saltSource;
    protected byte[] saltSourceData;
    protected long iterations;
    protected long pseudoRandomFunction;
    protected byte[] pseudoRandomFunctionData;

    public PKCS5PBKD2Params(long saltSource, byte[] saltSourceData, long iterations, long pseudoRandomFunction, byte[] pseudoRandomFunctionData) {
        if (saltSource != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"saltSource\": " + Long.toHexString(saltSource));
        }
        if (pseudoRandomFunction != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"pseudoRandomFunction\": " + Long.toHexString(pseudoRandomFunction));
        }
        this.saltSource = saltSource;
        this.saltSourceData = Util.requireNonNull("saltSourceData", saltSourceData);
        this.iterations = iterations;
        this.pseudoRandomFunction = pseudoRandomFunction;
        this.pseudoRandomFunctionData = Util.requireNonNull("pseudoRandomFunctionData", pseudoRandomFunctionData);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_PKCS5_PBKD2_PARAMS params = new CK_PKCS5_PBKD2_PARAMS();
        params.saltSource = this.saltSource;
        params.pSaltSourceData = this.saltSourceData;
        params.iterations = this.iterations;
        params.prf = this.pseudoRandomFunction;
        params.pPrfData = this.pseudoRandomFunctionData;
        return params;
    }

    public long getSaltSource() {
        return this.saltSource;
    }

    public byte[] getSaltSourceData() {
        return this.saltSourceData;
    }

    public long getIterations() {
        return this.iterations;
    }

    public long getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public byte[] getPseudoRandomFunctionData() {
        return this.pseudoRandomFunctionData;
    }

    public void setSaltSource(long saltSource) {
        if (saltSource != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"saltSource\": " + Long.toHexString(saltSource));
        }
        this.saltSource = saltSource;
    }

    public void setSaltSourceData(byte[] saltSourceData) {
        this.saltSourceData = Util.requireNonNull("saltSourceData", saltSourceData);
    }

    public void setIterations(long iterations) {
        this.iterations = iterations;
    }

    public void setPseudoRandomFunction(long pseudoRandomFunction) {
        if (pseudoRandomFunction != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"pseudoRandomFunction\": " + Long.toHexString(pseudoRandomFunction));
        }
        this.pseudoRandomFunction = pseudoRandomFunction;
    }

    public void setPseudoRandomFunctionData(byte[] pseudoRandomFunctionData) {
        this.pseudoRandomFunctionData = Util.requireNonNull("pseudoRandomFunctionData", pseudoRandomFunctionData);
    }

    public String toString() {
        return Util.concat("  Salt Source: ", this.saltSource == 1L ? "Salt Specified" : "<unknown>", "\n  Salt Source Data (hex): ", Util.toHex(this.saltSourceData), "\n  Iterations (dec): ", Long.toString(this.iterations), "\n  Pseudo-Random Function: ", this.pseudoRandomFunction == 1L ? "HMAC SHA-1" : "<unknown>", "\n  Pseudo-Random Function Data (hex): ", Util.toHex(this.pseudoRandomFunctionData));
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PKCS5PBKD2Params)) {
            return false;
        }
        PKCS5PBKD2Params other = (PKCS5PBKD2Params)otherObject;
        return this.saltSource == other.saltSource && Arrays.equals(this.saltSourceData, other.saltSourceData) && this.iterations == other.iterations && this.pseudoRandomFunction == other.pseudoRandomFunction && Arrays.equals(this.pseudoRandomFunctionData, other.pseudoRandomFunctionData);
    }

    public int hashCode() {
        return (int)this.saltSource ^ Util.hashCode(this.saltSourceData) ^ (int)this.iterations ^ (int)this.pseudoRandomFunction ^ Util.hashCode(this.pseudoRandomFunctionData);
    }

    public static interface SaltSourceType {
        public static final long SALT_SPECIFIED = 1L;
    }

    public static interface PseudoRandomFunctionType {
        public static final long HMAC_SHA1 = 1L;
    }
}

