/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.params;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.params.Params;
import java.util.Arrays;

public abstract class DHKeyDerivationParams
implements Params {
    protected long kdf;
    protected byte[] publicData;

    protected DHKeyDerivationParams(long kdf, byte[] publicData) {
        if (kdf != 1L && kdf != 2L && kdf != 3L && kdf != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"kdf\": " + Long.toHexString(kdf));
        }
        this.publicData = Util.requireNonNull("publicData", publicData);
        this.kdf = kdf;
    }

    public long getKeyDerivationFunction() {
        return this.kdf;
    }

    public byte[] getPublicData() {
        return this.publicData;
    }

    public void setKeyDerivationFunction(long kdf) {
        if (kdf != 1L && kdf != 2L && kdf != 3L && kdf != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"kdf\": " + Long.toHexString(kdf));
        }
        this.kdf = kdf;
    }

    public void setPublicData(byte[] publicData) {
        this.publicData = Util.requireNonNull("publicData", publicData);
    }

    public String toString() {
        String kdfStr = this.kdf == 1L ? "NULL" : (this.kdf == 2L ? "SHA1_KDF" : (this.kdf == 3L ? "SHA1_KDF_ASN1" : (this.kdf == 4L ? "SHA1_KDF_CONCATENATE" : "<unknown>")));
        return Util.concat("  Key Derivation Function: ", kdfStr, "\n  Public Data: ", Util.toHex(this.publicData));
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DHKeyDerivationParams)) {
            return false;
        }
        DHKeyDerivationParams other = (DHKeyDerivationParams)otherObject;
        return this.kdf == other.kdf && Arrays.equals(this.publicData, other.publicData);
    }

    public int hashCode() {
        return (int)this.kdf ^ Util.hashCode(this.publicData);
    }

    public static interface KeyDerivationFunctionType {
        public static final long NULL = 1L;
        public static final long SHA1_KDF = 2L;
        public static final long SHA1_KDF_ASN1 = 3L;
        public static final long SHA1_KDF_CONCATENATE = 4L;
    }
}

