/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class X942DHPrivateKey
extends DHPrivateKey {
    protected ByteArrayAttribute subprime;

    public X942DHPrivateKey() {
        this.keyType.setLongValue(Key.KeyType.X9_42_DH);
    }

    protected X942DHPrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(Key.KeyType.X9_42_DH);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X942DHPrivateKey(session, objectHandle);
    }

    protected static void putAttributesInTable(X942DHPrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.PRIME, object.prime);
        object.attributeTable.put(Attribute.BASE, object.base);
        object.attributeTable.put(Attribute.SUBPRIME, object.subprime);
        object.attributeTable.put(Attribute.VALUE, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute(Attribute.PRIME);
        this.base = new ByteArrayAttribute(Attribute.BASE);
        this.subprime = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        X942DHPrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof X942DHPrivateKey)) {
            return false;
        }
        X942DHPrivateKey other = (X942DHPrivateKey)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.base.equals(other.base) && this.subprime.equals(other.subprime) && this.value.equals(other.value);
    }

    @Override
    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    @Override
    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime;
    }

    @Override
    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.base, this.subprime});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.value);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Base (hex): ", this.base, "\n  Subprime (hex): ", this.subprime, "\n  Value (hex): ", this.value);
    }
}

