/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.SecretKey;

public class ValuedSecretKey
extends SecretKey {
    protected ByteArrayAttribute value;
    protected LongAttribute valueLen;

    public ValuedSecretKey(long keyType) {
        this.keyType.setLongValue(keyType);
    }

    protected ValuedSecretKey(Session session, long objectHandle, long keyType) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(keyType);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle, long keyType) throws TokenException {
        return new ValuedSecretKey(session, objectHandle, keyType);
    }

    protected static void putAttributesInTable(ValuedSecretKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.VALUE, object.value);
        object.attributeTable.put(Attribute.VALUE_LEN, object.valueLen);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen = new LongAttribute(Attribute.VALUE_LEN);
        ValuedSecretKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof ValuedSecretKey)) {
            return false;
        }
        ValuedSecretKey other = (ValuedSecretKey)otherObject;
        return super.equals(other) && this.value.equals(other.value) && this.valueLen.equals(other.valueLen);
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    public LongAttribute getValueLen() {
        return this.valueLen;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.value);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.valueLen);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Value (hex): ", this.value, this.valueLen.isPresent() ? "\n  Value Length (dec): " : this.valueLen.toString(10));
    }
}

