/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.ValuedSecretKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class SecretKey
extends Key {
    protected BooleanAttribute sensitive;
    protected BooleanAttribute encrypt;
    protected BooleanAttribute decrypt;
    protected BooleanAttribute sign;
    protected BooleanAttribute verify;
    protected BooleanAttribute wrap;
    protected BooleanAttribute unwrap;
    protected BooleanAttribute extractable;
    protected BooleanAttribute alwaysSensitive;
    protected BooleanAttribute neverExtractable;
    protected ByteArrayAttribute checkValue;
    protected BooleanAttribute wrapWithTrusted;
    protected BooleanAttribute trusted;
    protected AttributeArray wrapTemplate;
    protected AttributeArray unwrapTemplate;

    public SecretKey() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.SECRET_KEY);
    }

    protected SecretKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.SECRET_KEY);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        SecretKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = keyTypeAttribute.isPresent() && keyType != null ? ValuedSecretKey.getInstance(session, objectHandle, keyType) : SecretKey.getUnknownSecretKey(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownSecretKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (Key.vendorKeyBuilder != null) {
            try {
                newObject = Key.vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new SecretKey(session, objectHandle);
            }
        } else {
            newObject = new SecretKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(SecretKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.SENSITIVE, object.sensitive);
        object.attributeTable.put(Attribute.ENCRYPT, object.encrypt);
        object.attributeTable.put(Attribute.DECRYPT, object.decrypt);
        object.attributeTable.put(Attribute.SIGN, object.sign);
        object.attributeTable.put(Attribute.VERIFY, object.verify);
        object.attributeTable.put(Attribute.WRAP, object.wrap);
        object.attributeTable.put(Attribute.UNWRAP, object.unwrap);
        object.attributeTable.put(Attribute.EXTRACTABLE, object.extractable);
        object.attributeTable.put(Attribute.ALWAYS_SENSITIVE, object.alwaysSensitive);
        object.attributeTable.put(Attribute.NEVER_EXTRACTABLE, object.neverExtractable);
        object.attributeTable.put(Attribute.CHECK_VALUE, object.checkValue);
        object.attributeTable.put(Attribute.WRAP_WITH_TRUSTED, object.wrapWithTrusted);
        object.attributeTable.put(Attribute.TRUSTED, object.trusted);
        object.attributeTable.put(Attribute.WRAP_TEMPLATE, object.wrapTemplate);
        object.attributeTable.put(Attribute.UNWRAP_TEMPLATE, object.unwrapTemplate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.sensitive = new BooleanAttribute(Attribute.SENSITIVE);
        this.encrypt = new BooleanAttribute(Attribute.ENCRYPT);
        this.decrypt = new BooleanAttribute(Attribute.DECRYPT);
        this.sign = new BooleanAttribute(Attribute.SIGN);
        this.verify = new BooleanAttribute(Attribute.VERIFY);
        this.wrap = new BooleanAttribute(Attribute.WRAP);
        this.unwrap = new BooleanAttribute(Attribute.UNWRAP);
        this.extractable = new BooleanAttribute(Attribute.EXTRACTABLE);
        this.alwaysSensitive = new BooleanAttribute(Attribute.ALWAYS_SENSITIVE);
        this.neverExtractable = new BooleanAttribute(Attribute.NEVER_EXTRACTABLE);
        this.checkValue = new ByteArrayAttribute(Attribute.CHECK_VALUE);
        this.wrapWithTrusted = new BooleanAttribute(Attribute.WRAP_WITH_TRUSTED);
        this.trusted = new BooleanAttribute(Attribute.TRUSTED);
        this.wrapTemplate = new AttributeArray(Attribute.WRAP_TEMPLATE);
        this.unwrapTemplate = new AttributeArray(Attribute.UNWRAP_TEMPLATE);
        SecretKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof SecretKey)) {
            return false;
        }
        SecretKey other = (SecretKey)otherObject;
        return super.equals(other) && this.sensitive.equals(other.sensitive) && this.encrypt.equals(other.encrypt) && this.decrypt.equals(other.decrypt) && this.sign.equals(other.sign) && this.verify.equals(other.verify) && this.wrap.equals(other.wrap) && this.unwrap.equals(other.unwrap) && this.extractable.equals(other.extractable) && this.alwaysSensitive.equals(other.alwaysSensitive) && this.neverExtractable.equals(other.neverExtractable) && this.checkValue.equals(other.checkValue) && this.wrapWithTrusted.equals(other.wrapWithTrusted) && this.trusted.equals(other.trusted) && this.wrapTemplate.equals(other.wrapTemplate) && this.unwrapTemplate.equals(other.unwrapTemplate);
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt;
    }

    public BooleanAttribute getVerify() {
        return this.verify;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt;
    }

    public BooleanAttribute getSign() {
        return this.sign;
    }

    public BooleanAttribute getWrap() {
        return this.wrap;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable;
    }

    public ByteArrayAttribute getCheckValue() {
        return this.checkValue;
    }

    public BooleanAttribute getWrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted;
    }

    public AttributeArray getWrapTemplate() {
        return this.wrapTemplate;
    }

    public AttributeArray getUnwrapTemplate() {
        return this.unwrapTemplate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.sensitive, this.encrypt, this.decrypt, this.sign, this.verify, this.wrap, this.unwrap, this.extractable, this.alwaysSensitive, this.neverExtractable, this.checkValue, this.wrapWithTrusted, this.trusted});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.wrapTemplate);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.unwrapTemplate);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 200, superToString, "\n  Sensitive: ", this.sensitive, "\n  Encrypt: ", this.encrypt, "\n  Decrypt: ", this.decrypt, "\n  Sign: ", this.sign, "\n  Verify: ", this.verify, "\n  Wrap: ", this.wrap, "\n  Unwrap: ", this.unwrap, "\n  Extractable: ", this.extractable, "\n  Always Sensitive: ", this.alwaysSensitive, "\n  Never Extractable: ", this.neverExtractable, "\n  Check Value: ", this.checkValue, "\n  Wrap With Trusted: ", this.wrapWithTrusted, "\n  Trusted: ", this.trusted, "\n  Wrap Template: ", this.wrapTemplate, "\n  Unwrap Template: ", this.unwrapTemplate);
    }
}

