/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.SM2PrivateKey;
import iaik.pkcs.pkcs11.objects.X942DHPrivateKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PrivateKey
extends Key {
    protected ByteArrayAttribute subject;
    protected BooleanAttribute sensitive;
    protected BooleanAttribute secondaryAuth;
    protected LongAttribute authPinFlags;
    protected BooleanAttribute decrypt;
    protected BooleanAttribute sign;
    protected BooleanAttribute signRecover;
    protected BooleanAttribute unwrap;
    protected BooleanAttribute extractable;
    protected BooleanAttribute alwaysSensitive;
    protected BooleanAttribute neverExtractable;
    protected BooleanAttribute wrapWithTrusted;
    protected AttributeArray unwrapTemplate;
    protected BooleanAttribute alwaysAuthenticate;

    public PrivateKey() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.PRIVATE_KEY);
    }

    protected PrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.PRIVATE_KEY);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        PrivateKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = keyTypeAttribute.isPresent() && keyType != null ? (keyType.equals(Key.KeyType.RSA) ? RSAPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DSA) ? DSAPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.EC) ? ECPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DH) ? DHPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.KEA) ? KEAPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.X9_42_DH) ? X942DHPrivateKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.VENDOR_SM2) ? SM2PrivateKey.getInstance(session, objectHandle) : ((keyType & Key.KeyType.VENDOR_DEFINED) != 0L ? PrivateKey.getUnknownPrivateKey(session, objectHandle) : PrivateKey.getUnknownPrivateKey(session, objectHandle))))))))) : PrivateKey.getUnknownPrivateKey(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownPrivateKey(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (Key.vendorKeyBuilder != null) {
            try {
                newObject = Key.vendorKeyBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PrivateKey(session, objectHandle);
            }
        } else {
            newObject = new PrivateKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(PrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.SUBJECT, object.subject);
        object.attributeTable.put(Attribute.SENSITIVE, object.sensitive);
        object.attributeTable.put(Attribute.SECONDARY_AUTH, object.secondaryAuth);
        object.attributeTable.put(Attribute.AUTH_PIN_FLAGS, object.authPinFlags);
        object.attributeTable.put(Attribute.DECRYPT, object.decrypt);
        object.attributeTable.put(Attribute.SIGN, object.sign);
        object.attributeTable.put(Attribute.SIGN_RECOVER, object.signRecover);
        object.attributeTable.put(Attribute.UNWRAP, object.unwrap);
        object.attributeTable.put(Attribute.EXTRACTABLE, object.extractable);
        object.attributeTable.put(Attribute.ALWAYS_SENSITIVE, object.alwaysSensitive);
        object.attributeTable.put(Attribute.NEVER_EXTRACTABLE, object.neverExtractable);
        object.attributeTable.put(Attribute.WRAP_WITH_TRUSTED, object.wrapWithTrusted);
        object.attributeTable.put(Attribute.UNWRAP_TEMPLATE, object.unwrapTemplate);
        object.attributeTable.put(Attribute.ALWAYS_AUTHENTICATE, object.alwaysAuthenticate);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject = new ByteArrayAttribute(Attribute.SUBJECT);
        this.sensitive = new BooleanAttribute(Attribute.SENSITIVE);
        this.secondaryAuth = new BooleanAttribute(Attribute.SECONDARY_AUTH);
        this.authPinFlags = new LongAttribute(Attribute.AUTH_PIN_FLAGS);
        this.decrypt = new BooleanAttribute(Attribute.DECRYPT);
        this.sign = new BooleanAttribute(Attribute.SIGN);
        this.signRecover = new BooleanAttribute(Attribute.SIGN_RECOVER);
        this.unwrap = new BooleanAttribute(Attribute.UNWRAP);
        this.extractable = new BooleanAttribute(Attribute.EXTRACTABLE);
        this.alwaysSensitive = new BooleanAttribute(Attribute.ALWAYS_SENSITIVE);
        this.neverExtractable = new BooleanAttribute(Attribute.NEVER_EXTRACTABLE);
        this.wrapWithTrusted = new BooleanAttribute(Attribute.WRAP_WITH_TRUSTED);
        this.unwrapTemplate = new AttributeArray(Attribute.UNWRAP_TEMPLATE);
        this.alwaysAuthenticate = new BooleanAttribute(Attribute.ALWAYS_AUTHENTICATE);
        PrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PrivateKey)) {
            return false;
        }
        PrivateKey other = (PrivateKey)otherObject;
        return super.equals(other) && this.subject.equals(other.subject) && this.sensitive.equals(other.sensitive) && this.secondaryAuth.equals(other.secondaryAuth) && this.authPinFlags.equals(other.authPinFlags) && this.decrypt.equals(other.decrypt) && this.sign.equals(other.sign) && this.signRecover.equals(other.signRecover) && this.unwrap.equals(other.unwrap) && this.extractable.equals(other.extractable) && this.alwaysSensitive.equals(other.alwaysSensitive) && this.neverExtractable.equals(other.neverExtractable) && this.wrapWithTrusted.equals(other.wrapWithTrusted) && this.unwrapTemplate.equals(other.unwrapTemplate) && this.alwaysAuthenticate.equals(other.alwaysAuthenticate);
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive;
    }

    public BooleanAttribute getSecondaryAuth() {
        return this.secondaryAuth;
    }

    public LongAttribute getAuthPinFlags() {
        return this.authPinFlags;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt;
    }

    public BooleanAttribute getSign() {
        return this.sign;
    }

    public BooleanAttribute getSignRecover() {
        return this.signRecover;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable;
    }

    public BooleanAttribute getWrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    public AttributeArray getUnwrapTemplate() {
        return this.unwrapTemplate;
    }

    public BooleanAttribute getAlwaysAuthenticate() {
        return this.alwaysAuthenticate;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.subject, this.sensitive, this.secondaryAuth, this.authPinFlags, this.decrypt, this.sign, this.signRecover, this.unwrap, this.extractable, this.alwaysSensitive, this.neverExtractable, this.wrapWithTrusted, this.alwaysAuthenticate});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.unwrapTemplate);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  Subject (DER, hex): ").append(this.subject);
        sb.append("\n  Sensitive: ").append(this.sensitive);
        sb.append("\n  Secondary Authentication: ").append(this.secondaryAuth);
        sb.append("\n  Secondary Authentication PIN Flags: ");
        if (this.authPinFlags.isPresent() && !this.authPinFlags.isSensitive() && this.authPinFlags.getLongValue() != null) {
            long authFlagsValue = this.authPinFlags.getLongValue();
            sb.append("\n    User PIN-Count low: ").append((authFlagsValue & 0x10000L) != 0L);
            sb.append("\n    User PIN final Try: ").append((authFlagsValue & 0x20000L) != 0L);
            sb.append("\n    User PIN locked: ").append((authFlagsValue & 0x40000L) != 0L);
            sb.append("\n    User PIN to be changed: ").append((authFlagsValue & 0x80000L) != 0L);
        } else {
            sb.append(this.authPinFlags);
        }
        sb.append("\n  Decrypt: ").append(this.decrypt);
        sb.append("\n  Sign: ").append(this.sign);
        sb.append("\n  Sign Recover: ").append(this.signRecover);
        sb.append("\n  Unwrap: ").append(this.unwrap);
        sb.append("\n  Extractable: ").append(this.extractable);
        sb.append("\n  Always Sensitive: ").append(this.alwaysSensitive);
        sb.append("\n  Never Extractable: ").append(this.neverExtractable);
        sb.append("\n  Wrap With Trusted: ").append(this.wrapWithTrusted);
        sb.append("\n  Unwrap Template: ").append(this.unwrapTemplate);
        sb.append("\n  Always Authenticate: ").append(this.alwaysAuthenticate);
        return sb.toString();
    }
}

