/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.PKCS11Object;

public class MonotonicCounter
extends HardwareFeature {
    protected BooleanAttribute resetOnInit;
    protected BooleanAttribute hasReset;
    protected ByteArrayAttribute value;

    public MonotonicCounter() {
        this.hardwareFeatureType.setLongValue(HardwareFeature.FeatureType.MONOTONIC_COUNTER);
    }

    protected MonotonicCounter(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.hardwareFeatureType.setLongValue(HardwareFeature.FeatureType.MONOTONIC_COUNTER);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new MonotonicCounter(session, objectHandle);
    }

    protected static void putAttributesInTable(MonotonicCounter object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.RESET_ON_INIT, object.resetOnInit);
        object.attributeTable.put(Attribute.HAS_RESET, object.hasReset);
        object.attributeTable.put(Attribute.VALUE, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.resetOnInit = new BooleanAttribute(Attribute.RESET_ON_INIT);
        this.hasReset = new BooleanAttribute(Attribute.HAS_RESET);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        MonotonicCounter.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof MonotonicCounter)) {
            return false;
        }
        MonotonicCounter other = (MonotonicCounter)otherObject;
        return super.equals(other) && this.resetOnInit.equals(other.resetOnInit) && this.hasReset.equals(other.hasReset) && this.value.equals(other.value);
    }

    public BooleanAttribute getHasReset() {
        return this.hasReset;
    }

    public BooleanAttribute isResetOnInit() {
        return this.resetOnInit;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.resetOnInit.hashCode() ^ this.hasReset.hashCode() ^ this.value.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.resetOnInit, this.hasReset, this.value});
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Reset on Initialization: ", this.resetOnInit, "\n  Has been reset: ", this.hasReset, "\n  Value (hex): ", this.value);
    }
}

