/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Clock;
import iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MonotonicCounter;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class HardwareFeature
extends PKCS11Object {
    protected static VendorDefinedHardwareFeatureBuilder vendorHardwareFeatureBuilder;
    protected HardwareFeatureTypeAttribute hardwareFeatureType;

    public HardwareFeature() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.HW_FEATURE);
    }

    protected HardwareFeature(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.HW_FEATURE);
    }

    public static String getHardwareFeatureTypeName(Long hardwareFeatureType) {
        Util.requireNonNull("hardwareFeatureType", hardwareFeatureType);
        String hardwareFeatureTypeName = hardwareFeatureType.equals(FeatureType.MONOTONIC_COUNTER) ? "Monotonic Counter" : (hardwareFeatureType.equals(FeatureType.CLOCK) ? "Clock" : (hardwareFeatureType.equals(FeatureType.USER_INTERFACE) ? "User Interface" : ((hardwareFeatureType & FeatureType.VENDOR_DEFINED) != 0L ? "Vendor Defined" : "<unknown>")));
        return hardwareFeatureTypeName;
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        HardwareFeatureTypeAttribute hardwareFeatureTypeAttribute = new HardwareFeatureTypeAttribute();
        HardwareFeature.getAttributeValue(session, objectHandle, hardwareFeatureTypeAttribute);
        Long hardwareFeatureType = hardwareFeatureTypeAttribute.getLongValue();
        PKCS11Object newObject = hardwareFeatureTypeAttribute.isPresent() && hardwareFeatureType != null ? (hardwareFeatureType.equals(FeatureType.MONOTONIC_COUNTER) ? MonotonicCounter.getInstance(session, objectHandle) : (hardwareFeatureType.equals(FeatureType.CLOCK) ? Clock.getInstance(session, objectHandle) : (hardwareFeatureType.equals(FeatureType.USER_INTERFACE) ? HardwareFeature.getUnknownHardwareFeature(session, objectHandle) : ((hardwareFeatureType & FeatureType.VENDOR_DEFINED) != 0L ? HardwareFeature.getUnknownHardwareFeature(session, objectHandle) : HardwareFeature.getUnknownHardwareFeature(session, objectHandle))))) : HardwareFeature.getUnknownHardwareFeature(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownHardwareFeature(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (vendorHardwareFeatureBuilder != null) {
            try {
                newObject = vendorHardwareFeatureBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new HardwareFeature(session, objectHandle);
            }
        } else {
            newObject = new HardwareFeature(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedHardwareFeatureBuilder(VendorDefinedHardwareFeatureBuilder builder) {
        vendorHardwareFeatureBuilder = builder;
    }

    public static VendorDefinedHardwareFeatureBuilder getVendorDefinedHardwareFeatureBuilder() {
        return vendorHardwareFeatureBuilder;
    }

    protected static void putAttributesInTable(HardwareFeature object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.HW_FEATURE_TYPE, object.hardwareFeatureType);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.hardwareFeatureType = new HardwareFeatureTypeAttribute();
        HardwareFeature.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof HardwareFeature)) {
            return false;
        }
        HardwareFeature other = (HardwareFeature)otherObject;
        return super.equals(other) && this.hardwareFeatureType.equals(other.hardwareFeatureType);
    }

    public LongAttribute getHardwareFeatureType() {
        return this.hardwareFeatureType;
    }

    @Override
    public int hashCode() {
        return this.hardwareFeatureType.hashCode();
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Hardware Feature Type: ", this.hardwareFeatureType != null ? this.hardwareFeatureType.toString() : "<unavailable>");
    }

    public static interface VendorDefinedHardwareFeatureBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }

    public static interface FeatureType {
        public static final Long MONOTONIC_COUNTER = new Long(1L);
        public static final Long CLOCK = new Long(2L);
        public static final Long USER_INTERFACE = new Long(3L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }
}

