/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import java.util.Enumeration;

public class GenericTemplate
extends PKCS11Object {
    public GenericTemplate() {
        this.attributeTable.clear();
    }

    public void addAttribute(Attribute attribute) {
        Util.requireNonNull("attribute", attribute);
        this.attributeTable.put(attribute.getType(), attribute);
    }

    public void addAllAttributes(PKCS11Object object) {
        Util.requireNonNull("object", object);
        Enumeration<Long> newAttributeKeysEnumeration = object.attributeTable.keys();
        while (newAttributeKeysEnumeration.hasMoreElements()) {
            Long newKey = newAttributeKeysEnumeration.nextElement();
            this.attributeTable.put(newKey, object.attributeTable.get(newKey));
        }
    }

    public void addAllPresentAttributes(PKCS11Object object) {
        Util.requireNonNull("object", object);
        Enumeration<Attribute> attributeEnumaeration = object.attributeTable.elements();
        while (attributeEnumaeration.hasMoreElements()) {
            Attribute attribute = attributeEnumaeration.nextElement();
            if (!attribute.isPresent()) continue;
            this.attributeTable.put(attribute.getType(), attribute);
        }
    }

    public boolean containsAttribute(Attribute attribute) {
        Util.requireNonNull("attribute", attribute);
        return this.attributeTable.containsKey(attribute.getType());
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof GenericTemplate)) {
            return false;
        }
        GenericTemplate other = (GenericTemplate)otherObject;
        return this.attributeTable.equals(other.attributeTable);
    }

    @Override
    public int hashCode() {
        return this.attributeTable.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        if (this.objectHandle == -1L) {
            throw new TokenException("PKCS11Object handle is not set to an valid value. Use setObjectHandle(long) to set.");
        }
        super.readAttributes(session);
        Enumeration attributeEnumeration = this.attributeTable.elements();
        while (attributeEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)attributeEnumeration.nextElement();
            PKCS11Object.getAttributeValue(session, this.objectHandle, attribute);
        }
    }

    public Attribute removeAttribute(Attribute attribute) {
        Util.requireNonNull("attribute", attribute);
        return (Attribute)this.attributeTable.remove(attribute.getType());
    }

    public void removeAllAttributes(PKCS11Object object) {
        Util.requireNonNull("object", object);
        Enumeration<Long> keysToRemove = object.attributeTable.keys();
        while (keysToRemove.hasMoreElements()) {
            this.attributeTable.remove(keysToRemove.nextElement());
        }
    }

    public void removeAllPresentAttributes(PKCS11Object object) {
        Util.requireNonNull("object", object);
        Enumeration<Long> keysToRemove = object.attributeTable.keys();
        while (keysToRemove.hasMoreElements()) {
            Long key = keysToRemove.nextElement();
            Attribute attribute = object.attributeTable.get(key);
            if (!attribute.isPresent()) continue;
            this.attributeTable.remove(key);
        }
    }

    protected void setAllPresentFlags(boolean present) {
        Enumeration attributesEnumeration = this.attributeTable.elements();
        while (attributesEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)attributesEnumeration.nextElement();
            attribute.setPresent(present);
        }
    }

    @Override
    public String toString() {
        return this.toString(false, true, "  ");
    }

    @Override
    public String toString(boolean newline, boolean withName, String indent) {
        boolean firstAttribute;
        StringBuilder sb = new StringBuilder(1024);
        Enumeration attributesEnumeration = this.attributeTable.elements();
        boolean bl = firstAttribute = !newline;
        while (attributesEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)attributesEnumeration.nextElement();
            if (!attribute.isPresent()) continue;
            if (!firstAttribute) {
                sb.append("\n");
            }
            sb.append(indent);
            sb.append(attribute.toString(withName));
            firstAttribute = false;
        }
        return sb.toString();
    }
}

