/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.DHParams;
import iaik.pkcs.pkcs11.objects.DSAParams;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X942DHParams;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class DomainParameters
extends Storage {
    protected static VendorDefinedDomainParametersBuilder vendorDomainParametersBuilder;
    protected KeyTypeAttribute keyType;
    protected BooleanAttribute local;

    public DomainParameters() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.DOMAIN_PARAMETERS);
    }

    protected DomainParameters(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.DOMAIN_PARAMETERS);
    }

    public static void setVendorDefinedDomainParametersBuilder(VendorDefinedDomainParametersBuilder builder) {
        vendorDomainParametersBuilder = builder;
    }

    public static VendorDefinedDomainParametersBuilder getVendorDefinedDomainParametersBuilder() {
        return vendorDomainParametersBuilder;
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        Util.requireNonNull("session", session);
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        DomainParameters.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        PKCS11Object newObject = keyTypeAttribute.isPresent() && keyType != null ? (keyType.equals(Key.KeyType.DSA) ? DSAParams.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DH) ? DHParams.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.X9_42_DH) ? X942DHParams.getInstance(session, objectHandle) : ((keyType & Key.KeyType.VENDOR_DEFINED) != 0L ? DomainParameters.getUnknownDomainParameters(session, objectHandle) : DomainParameters.getUnknownDomainParameters(session, objectHandle))))) : DomainParameters.getUnknownDomainParameters(session, objectHandle);
        return newObject;
    }

    protected static PKCS11Object getUnknownDomainParameters(Session session, long objectHandle) throws TokenException {
        PKCS11Object newObject;
        Util.requireNonNull("session", session);
        if (vendorDomainParametersBuilder != null) {
            try {
                newObject = vendorDomainParametersBuilder.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new DomainParameters(session, objectHandle);
            }
        } else {
            newObject = new DomainParameters(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(DomainParameters object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.KEY_TYPE, object.keyType);
        object.attributeTable.put(Attribute.LOCAL, object.local);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType = new KeyTypeAttribute();
        this.local = new BooleanAttribute(Attribute.LOCAL);
        DomainParameters.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DomainParameters)) {
            return false;
        }
        DomainParameters other = (DomainParameters)otherObject;
        return super.equals(other) && this.keyType.equals(other.keyType) && this.local.equals(other.local);
    }

    public LongAttribute getKeyType() {
        return this.keyType;
    }

    @Override
    public int hashCode() {
        return this.keyType.hashCode() ^ this.local.hashCode();
    }

    public BooleanAttribute isLocal() {
        return this.local;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.local);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Key Type: ", this.keyType != null ? this.keyType : "<unavailable>", "\n  Local: ", this.local);
    }

    public static interface VendorDefinedDomainParametersBuilder {
        public PKCS11Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

