/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.Storage;

public class Data
extends Storage {
    protected CharArrayAttribute application;
    protected ByteArrayAttribute objectID;
    protected ByteArrayAttribute value;

    public Data() {
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.DATA);
    }

    protected Data(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass.setLongValue(PKCS11Object.ObjectClass.DATA);
    }

    protected static void putAttributesInTable(Data object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.APPLICATION, object.application);
        object.attributeTable.put(Attribute.OBJECT_ID, object.objectID);
        object.attributeTable.put(Attribute.VALUE, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.application = new CharArrayAttribute(Attribute.APPLICATION);
        this.objectID = new ByteArrayAttribute(Attribute.OBJECT_ID);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        Data.putAttributesInTable(this);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new Data(session, objectHandle);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Data)) {
            return false;
        }
        Data other = (Data)otherObject;
        return super.equals(other) && this.application.equals(other.application) && this.objectID.equals(other.objectID) && this.value.equals(other.value);
    }

    public CharArrayAttribute getApplication() {
        return this.application;
    }

    public ByteArrayAttribute getObjectID() {
        return this.objectID;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.application.hashCode() ^ this.objectID.hashCode() ^ this.value.hashCode();
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.application);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.objectID);
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.value);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Application: ", this.application, "\n  PKCS11Object ID (DER, hex): ", this.objectID, "\n  Value (hex): ", this.value);
    }
}

