/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;

public class DSAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute prime;
    protected ByteArrayAttribute subprime;
    protected ByteArrayAttribute base;
    protected ByteArrayAttribute value;

    public DSAPrivateKey() {
        this.keyType.setLongValue(Key.KeyType.DSA);
    }

    protected DSAPrivateKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType.setLongValue(Key.KeyType.DSA);
    }

    public static PKCS11Object getInstance(Session session, long objectHandle) throws TokenException {
        return new DSAPrivateKey(session, objectHandle);
    }

    protected static void putAttributesInTable(DSAPrivateKey object) {
        Util.requireNonNull("object", object);
        object.attributeTable.put(Attribute.PRIME, object.prime);
        object.attributeTable.put(Attribute.SUBPRIME, object.subprime);
        object.attributeTable.put(Attribute.BASE, object.base);
        object.attributeTable.put(Attribute.VALUE, object.value);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base = new ByteArrayAttribute(Attribute.BASE);
        this.value = new ByteArrayAttribute(Attribute.VALUE);
        DSAPrivateKey.putAttributesInTable(this);
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey other = (DSAPrivateKey)otherObject;
        return super.equals(other) && this.prime.equals(other.prime) && this.subprime.equals(other.subprime) && this.base.equals(other.base) && this.value.equals(other.value);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime;
    }

    public ByteArrayAttribute getBase() {
        return this.base;
    }

    public ByteArrayAttribute getValue() {
        return this.value;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        PKCS11Object.getAttributeValues(session, this.objectHandle, new Attribute[]{this.prime, this.subprime, this.base});
        PKCS11Object.getAttributeValue(session, this.objectHandle, this.value);
    }

    @Override
    public String toString() {
        String superToString = super.toString();
        return Util.concatObjectsCap(superToString.length() + 100, superToString, "\n  Prime (hex): ", this.prime, "\n  Subprime (hex): ", this.subprime, "\n  Base (hex): ", this.base, "\n  Value (hex): ", this.value);
    }
}

