/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.MechanismAttribute;
import iaik.pkcs.pkcs11.objects.ObjectClassAttribute;
import java.util.HashSet;
import java.util.Hashtable;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public abstract class Attribute {
    public static final Long CLASS = new Long(0L);
    public static final Long TOKEN = new Long(1L);
    public static final Long PRIVATE = new Long(2L);
    public static final Long LABEL = new Long(3L);
    public static final Long APPLICATION = new Long(16L);
    public static final Long VALUE = new Long(17L);
    public static final Long OBJECT_ID = new Long(18L);
    public static final Long CERTIFICATE_TYPE = new Long(128L);
    public static final Long ISSUER = new Long(129L);
    public static final Long SERIAL_NUMBER = new Long(130L);
    public static final Long URL = new Long(137L);
    public static final Long HASH_OF_SUBJECT_PUBLIC_KEY = new Long(138L);
    public static final Long HASH_OF_ISSUER_PUBLIC_KEY = new Long(139L);
    public static final Long JAVA_MIDP_SECURITY_DOMAIN = new Long(136L);
    public static final Long AC_ISSUER = new Long(131L);
    public static final Long OWNER = new Long(132L);
    public static final Long ATTR_TYPES = new Long(133L);
    public static final Long TRUSTED = new Long(134L);
    public static final Long KEY_TYPE = new Long(256L);
    public static final Long SUBJECT = new Long(257L);
    public static final Long ID = new Long(258L);
    public static final Long CHECK_VALUE = new Long(144L);
    public static final Long CERTIFICATE_CATEGORY = new Long(135L);
    public static final Long SENSITIVE = new Long(259L);
    public static final Long ENCRYPT = new Long(260L);
    public static final Long DECRYPT = new Long(261L);
    public static final Long WRAP = new Long(262L);
    public static final Long WRAP_TEMPLATE = new Long(1073742353L);
    public static final Long UNWRAP = new Long(263L);
    public static final Long UNWRAP_TEMPLATE = new Long(1073742354L);
    public static final Long SIGN = new Long(264L);
    public static final Long SIGN_RECOVER = new Long(265L);
    public static final Long VERIFY = new Long(266L);
    public static final Long VERIFY_RECOVER = new Long(267L);
    public static final Long DERIVE = new Long(268L);
    public static final Long START_DATE = new Long(272L);
    public static final Long END_DATE = new Long(273L);
    public static final Long MECHANISM_TYPE = new Long(1280L);
    public static final Long MODULUS = new Long(288L);
    public static final Long MODULUS_BITS = new Long(289L);
    public static final Long PUBLIC_EXPONENT = new Long(290L);
    public static final Long PRIVATE_EXPONENT = new Long(291L);
    public static final Long PRIME_1 = new Long(292L);
    public static final Long PRIME_2 = new Long(293L);
    public static final Long EXPONENT_1 = new Long(294L);
    public static final Long EXPONENT_2 = new Long(295L);
    public static final Long COEFFICIENT = new Long(296L);
    public static final Long PRIME = new Long(304L);
    public static final Long SUBPRIME = new Long(305L);
    public static final Long BASE = new Long(306L);
    public static final Long PRIME_BITS = new Long(307L);
    public static final Long SUB_PRIME_BITS = new Long(308L);
    public static final Long VALUE_BITS = new Long(352L);
    public static final Long VALUE_LEN = new Long(353L);
    public static final Long EXTRACTABLE = new Long(354L);
    public static final Long LOCAL = new Long(355L);
    public static final Long NEVER_EXTRACTABLE = new Long(356L);
    public static final Long WRAP_WITH_TRUSTED = new Long(528L);
    public static final Long ALWAYS_SENSITIVE = new Long(357L);
    public static final Long ALWAYS_AUTHENTICATE = new Long(514L);
    public static final Long KEY_GEN_MECHANISM = new Long(358L);
    public static final Long ALLOWED_MECHANISMS = new Long(0x40000600L);
    public static final Long MODIFIABLE = new Long(368L);
    public static final Long EC_PARAMS = new Long(384L);
    public static final Long EC_POINT = new Long(385L);
    public static final Long SECONDARY_AUTH = new Long(512L);
    public static final Long AUTH_PIN_FLAGS = new Long(513L);
    public static final Long HW_FEATURE_TYPE = new Long(768L);
    public static final Long RESET_ON_INIT = new Long(769L);
    public static final Long HAS_RESET = new Long(770L);
    public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    public static final Long PIXEL_X = new Long(1024L);
    public static final Long PIXEL_Y = new Long(1025L);
    public static final Long RESOLUTION = new Long(1026L);
    public static final Long CHAR_ROWS = new Long(1027L);
    public static final Long CHAR_COLUMNS = new Long(1028L);
    public static final Long COLOR = new Long(1029L);
    public static final Long BITS_PER_PIXEL = new Long(1030L);
    public static final Long CHAR_SETS = new Long(1152L);
    public static final Long ENCODING_METHODS = new Long(1153L);
    public static final Long MIME_TYPES = new Long(1154L);
    protected static Hashtable<Long, String> attributeNames;
    protected static Hashtable<Long, Class<?>> attributeClasses;
    protected boolean present;
    protected boolean sensitive;
    protected CK_ATTRIBUTE ckAttribute;

    protected Attribute() {
    }

    protected Attribute(Long type) {
        Util.requireNonNull("type", type);
        this.present = false;
        this.sensitive = false;
        this.ckAttribute = new CK_ATTRIBUTE();
        this.ckAttribute.type = type;
    }

    protected static synchronized String getAttributeName(Long type) {
        String name;
        Util.requireNonNull("type", type);
        if (attributeNames == null) {
            attributeNames = new Hashtable(85);
            attributeNames.put(CLASS, "Class");
            attributeNames.put(TOKEN, "Token");
            attributeNames.put(PRIVATE, "Private");
            attributeNames.put(LABEL, "Label");
            attributeNames.put(APPLICATION, "Application");
            attributeNames.put(VALUE, "Value");
            attributeNames.put(OBJECT_ID, "PKCS11Object ID");
            attributeNames.put(CERTIFICATE_TYPE, "Certificate Type");
            attributeNames.put(ISSUER, "Issuer");
            attributeNames.put(SERIAL_NUMBER, "Serial Number");
            attributeNames.put(URL, "URL");
            attributeNames.put(HASH_OF_SUBJECT_PUBLIC_KEY, "Hash Of Subject Public Key");
            attributeNames.put(HASH_OF_ISSUER_PUBLIC_KEY, "Hash Of Issuer Public Key");
            attributeNames.put(JAVA_MIDP_SECURITY_DOMAIN, "Java MIDP Security Domain");
            attributeNames.put(AC_ISSUER, "AC Issuer");
            attributeNames.put(OWNER, "Owner");
            attributeNames.put(ATTR_TYPES, "Attribute Types");
            attributeNames.put(TRUSTED, "Trusted");
            attributeNames.put(KEY_TYPE, "Key Type");
            attributeNames.put(SUBJECT, "Subject");
            attributeNames.put(ID, "ID");
            attributeNames.put(CHECK_VALUE, "Check Value");
            attributeNames.put(CERTIFICATE_CATEGORY, "Certificate Category");
            attributeNames.put(SENSITIVE, "Sensitive");
            attributeNames.put(ENCRYPT, "Encrypt");
            attributeNames.put(DECRYPT, "Decrypt");
            attributeNames.put(WRAP, "Wrap");
            attributeNames.put(UNWRAP, "Unwrap");
            attributeNames.put(WRAP_TEMPLATE, "Wrap Template");
            attributeNames.put(UNWRAP_TEMPLATE, "Unwrap Template");
            attributeNames.put(SIGN, "Sign");
            attributeNames.put(SIGN_RECOVER, "Sign Recover");
            attributeNames.put(VERIFY, "Verify");
            attributeNames.put(VERIFY_RECOVER, "Verify Recover");
            attributeNames.put(DERIVE, "Derive");
            attributeNames.put(START_DATE, "Start Date");
            attributeNames.put(END_DATE, "End Date");
            attributeNames.put(MODULUS, "Modulus");
            attributeNames.put(MODULUS_BITS, "Modulus Bits");
            attributeNames.put(PUBLIC_EXPONENT, "Public Exponent");
            attributeNames.put(PRIVATE_EXPONENT, "Private Exponent");
            attributeNames.put(PRIME_1, "Prime 1");
            attributeNames.put(PRIME_2, "Prime 2");
            attributeNames.put(EXPONENT_1, "Exponent 1");
            attributeNames.put(EXPONENT_2, "Exponent 2");
            attributeNames.put(COEFFICIENT, "Coefficient");
            attributeNames.put(PRIME, "Prime");
            attributeNames.put(SUBPRIME, "Subprime");
            attributeNames.put(BASE, "Base");
            attributeNames.put(PRIME_BITS, "Prime Pits");
            attributeNames.put(SUB_PRIME_BITS, "Subprime Bits");
            attributeNames.put(VALUE_BITS, "Value Bits");
            attributeNames.put(VALUE_LEN, "Value Length");
            attributeNames.put(EXTRACTABLE, "Extractable");
            attributeNames.put(LOCAL, "Local");
            attributeNames.put(NEVER_EXTRACTABLE, "Never Extractable");
            attributeNames.put(WRAP_WITH_TRUSTED, "Wrap With Trusted");
            attributeNames.put(ALWAYS_SENSITIVE, "Always Sensitive");
            attributeNames.put(ALWAYS_AUTHENTICATE, "Always Authenticate");
            attributeNames.put(KEY_GEN_MECHANISM, "Key Generation Mechanism");
            attributeNames.put(ALLOWED_MECHANISMS, "Allowed Mechanisms");
            attributeNames.put(MODIFIABLE, "Modifiable");
            attributeNames.put(EC_PARAMS, "EC Parameters");
            attributeNames.put(EC_POINT, "EC Point");
            attributeNames.put(SECONDARY_AUTH, "Secondary Authentication");
            attributeNames.put(AUTH_PIN_FLAGS, "Authentication PIN Flags");
            attributeNames.put(HW_FEATURE_TYPE, "Hardware Feature Type");
            attributeNames.put(RESET_ON_INIT, "Reset on Initialization");
            attributeNames.put(HAS_RESET, "Has been reset");
            attributeNames.put(VENDOR_DEFINED, "Vendor Defined");
        }
        if ((type & VENDOR_DEFINED) != 0L) {
            StringBuilder nameBuffer = new StringBuilder(36);
            nameBuffer.append("VENDOR_DEFINED [0x");
            nameBuffer.append(Long.toHexString(type));
            nameBuffer.append(']');
            name = nameBuffer.toString();
        } else {
            name = attributeNames.get(type);
            if (name == null) {
                StringBuilder nameBuffer = new StringBuilder(25);
                nameBuffer.append("[0x");
                nameBuffer.append(Long.toHexString(type));
                nameBuffer.append(']');
                name = nameBuffer.toString();
            }
        }
        return name;
    }

    protected static synchronized Class<?> getAttributeClass(Long type) {
        Util.requireNonNull("type", type);
        if (attributeClasses == null) {
            HashSet<Long> boolSet = new HashSet<Long>();
            HashSet<Long> longSet = new HashSet<Long>();
            HashSet<Long> barrSet = new HashSet<Long>();
            HashSet<Long> carrSet = new HashSet<Long>();
            attributeClasses = new Hashtable(85);
            attributeClasses.put(CLASS, ObjectClassAttribute.class);
            boolSet.add(TOKEN);
            boolSet.add(PRIVATE);
            carrSet.add(LABEL);
            carrSet.add(APPLICATION);
            barrSet.add(VALUE);
            barrSet.add(OBJECT_ID);
            attributeClasses.put(CERTIFICATE_TYPE, CertificateTypeAttribute.class);
            barrSet.add(ISSUER);
            barrSet.add(SERIAL_NUMBER);
            carrSet.add(URL);
            barrSet.add(HASH_OF_SUBJECT_PUBLIC_KEY);
            barrSet.add(HASH_OF_ISSUER_PUBLIC_KEY);
            longSet.add(JAVA_MIDP_SECURITY_DOMAIN);
            barrSet.add(AC_ISSUER);
            barrSet.add(OWNER);
            barrSet.add(ATTR_TYPES);
            boolSet.add(TRUSTED);
            attributeClasses.put(KEY_TYPE, KeyTypeAttribute.class);
            barrSet.add(SUBJECT);
            barrSet.add(ID);
            barrSet.add(CHECK_VALUE);
            longSet.add(CERTIFICATE_CATEGORY);
            boolSet.add(SENSITIVE);
            boolSet.add(ENCRYPT);
            boolSet.add(DECRYPT);
            boolSet.add(WRAP);
            boolSet.add(UNWRAP);
            attributeClasses.put(WRAP_TEMPLATE, AttributeArray.class);
            attributeClasses.put(UNWRAP_TEMPLATE, AttributeArray.class);
            boolSet.add(SIGN);
            boolSet.add(SIGN_RECOVER);
            boolSet.add(VERIFY);
            boolSet.add(VERIFY_RECOVER);
            boolSet.add(DERIVE);
            attributeClasses.put(START_DATE, DateAttribute.class);
            attributeClasses.put(END_DATE, DateAttribute.class);
            barrSet.add(MODULUS);
            attributeClasses.put(MODULUS_BITS, LongAttribute.class);
            barrSet.add(PUBLIC_EXPONENT);
            barrSet.add(PRIVATE_EXPONENT);
            barrSet.add(PRIME_1);
            barrSet.add(PRIME_2);
            barrSet.add(EXPONENT_1);
            barrSet.add(EXPONENT_2);
            barrSet.add(COEFFICIENT);
            barrSet.add(PRIME);
            barrSet.add(SUBPRIME);
            barrSet.add(BASE);
            longSet.add(PRIME_BITS);
            longSet.add(SUB_PRIME_BITS);
            longSet.add(VALUE_BITS);
            longSet.add(VALUE_LEN);
            boolSet.add(EXTRACTABLE);
            boolSet.add(LOCAL);
            boolSet.add(NEVER_EXTRACTABLE);
            boolSet.add(WRAP_WITH_TRUSTED);
            boolSet.add(ALWAYS_SENSITIVE);
            boolSet.add(ALWAYS_AUTHENTICATE);
            attributeClasses.put(KEY_GEN_MECHANISM, MechanismAttribute.class);
            attributeClasses.put(ALLOWED_MECHANISMS, MechanismArrayAttribute.class);
            boolSet.add(MODIFIABLE);
            barrSet.add(EC_PARAMS);
            barrSet.add(EC_POINT);
            boolSet.add(SECONDARY_AUTH);
            longSet.add(AUTH_PIN_FLAGS);
            attributeClasses.put(HW_FEATURE_TYPE, HardwareFeatureTypeAttribute.class);
            boolSet.add(RESET_ON_INIT);
            boolSet.add(HAS_RESET);
            for (Long m : boolSet) {
                attributeClasses.put(m, BooleanAttribute.class);
            }
            for (Long m : longSet) {
                attributeClasses.put(m, LongAttribute.class);
            }
            for (Long m : barrSet) {
                attributeClasses.put(m, ByteArrayAttribute.class);
            }
            for (Long m : carrSet) {
                attributeClasses.put(m, CharArrayAttribute.class);
            }
        }
        Class<?> implementation = attributeClasses.get(type);
        return implementation;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public abstract void setValue(Object var1);

    protected void setCkAttribute(CK_ATTRIBUTE ckAttribute) {
        this.ckAttribute = Util.requireNonNull("ckAttribute", ckAttribute);
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    protected CK_ATTRIBUTE getCkAttribute() {
        return this.ckAttribute;
    }

    protected String getValueString() {
        if (this.ckAttribute != null && this.ckAttribute.pValue != null) {
            return this.ckAttribute.pValue.toString();
        }
        return "<NULL_PTR>";
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withName) {
        StringBuilder sb = new StringBuilder(32);
        if (withName) {
            String typeName = Attribute.getAttributeName(new Long(this.ckAttribute.type));
            sb.append(typeName).append(": ");
        }
        if (this.present) {
            if (this.sensitive) {
                sb.append("<Value is sensitive>");
            } else {
                sb.append(this.getValueString());
            }
        } else {
            sb.append("<Attribute not present>");
        }
        return sb.toString();
    }

    protected void setType(Long type) {
        Util.requireNonNull("type", type);
        this.ckAttribute.type = type;
    }

    protected Long getType() {
        return new Long(this.ckAttribute.type);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)otherObject;
        if (!this.present && !other.present) {
            return true;
        }
        if (!this.present || !other.present) {
            return false;
        }
        if (this.sensitive != other.sensitive) {
            return false;
        }
        if (this.ckAttribute.type != other.ckAttribute.type) {
            return false;
        }
        return Util.objEquals(this.ckAttribute.pValue, other.ckAttribute.pValue);
    }

    public int hashCode() {
        int valueHashCode = this.ckAttribute.pValue != null ? this.ckAttribute.pValue.hashCode() : 0;
        return (int)this.ckAttribute.type ^ valueHashCode;
    }
}

