/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import sun.security.pkcs11.wrapper.CK_VERSION;

public class Version {
    private byte major;
    private byte minor;

    public Version(byte major, byte minor) {
        this.major = major;
        this.minor = minor;
    }

    public Version(CK_VERSION ckVersion) {
        Util.requireNonNull("ckVersion", ckVersion);
        this.major = ckVersion.major;
        this.minor = ckVersion.minor;
    }

    public void setMajor(byte major) {
        this.major = major;
    }

    public void setMinor(byte minor) {
        this.minor = minor;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public String toString() {
        return Util.concatObjects(this.major & 0xFF, ".", this.minor < 10 ? "0" : "", this.minor & 0xFF);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Version)) {
            return false;
        }
        Version other = (Version)otherObject;
        return this.major == other.major && this.minor == other.minor;
    }

    public int hashCode() {
        return this.major ^ this.minor;
    }
}

